/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.api;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.evrete.api.KeyMode;
import org.evrete.api.KeyReIterators;
import org.evrete.api.ReIterable;

public interface KeyReIterables<K> {
    public EnumMap<KeyMode, ReIterable<K>> keyIterables();

    default public KeyReIterators<K> keyIterators() {
        return this.keyIterators((K k) -> k);
    }

    default public <Z> KeyReIterators<Z> keyIterators(Supplier<Function<K, Z>> mapperSupplier) {
        EnumMap map = new EnumMap(KeyMode.class);
        for (Map.Entry<KeyMode, ReIterable<K>> entry : this.keyIterables().entrySet()) {
            Function<K, Z> mapper = mapperSupplier.get();
            map.put(entry.getKey(), entry.getValue().iterator(mapper));
        }
        return () -> map;
    }

    default public <Z> KeyReIterators<Z> keyIterators(Function<K, Z> mapper) {
        EnumMap map = new EnumMap(KeyMode.class);
        for (Map.Entry<KeyMode, ReIterable<K>> entry : this.keyIterables().entrySet()) {
            map.put(entry.getKey(), entry.getValue().iterator(mapper));
        }
        return () -> map;
    }
}

