/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.evrete.api.Evaluator;
import org.evrete.api.NamedType;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.builder.AbstractLhsBuilder;
import org.evrete.runtime.builder.FactTypeBuilder;
import org.evrete.runtime.evaluation.EvaluatorFactory;
import org.evrete.runtime.evaluation.EvaluatorGroup;
import org.evrete.util.MapFunction;
import org.evrete.util.NextIntSupplier;

public abstract class AbstractLhsDescriptor {
    private final MapFunction<String, int[]> nameIndices = new MapFunction();
    private final int level;
    private final Set<FactType> groupFactTypes = new HashSet<FactType>();
    private final RhsFactGroupDescriptor[] allFactGroups;

    AbstractLhsDescriptor(AbstractRuntime<?> runtime, AbstractLhsDescriptor parent, AbstractLhsBuilder<?, ?> group, NextIntSupplier factIdGenerator, MapFunction<NamedType, FactType> typeMapping) {
        this.level = parent == null ? 0 : parent.level + 1;
        Set<FactTypeBuilder> declaredTypes = group.getDeclaredFactTypes();
        AbstractLhsBuilder.Compiled compiledConditions = group.getCompiledData();
        HashSet<FactType> keyedFactTypes = new HashSet<FactType>();
        ArrayList<FactType> alphaFactTypes = new ArrayList<FactType>();
        for (FactTypeBuilder builder : declaredTypes) {
            Set<Evaluator> alphaConditions;
            FactType factType = FactType.factory(runtime, builder, alphaConditions = compiledConditions.getAlphaConditions(builder), factIdGenerator);
            if (factType.getFields().size() == 0) {
                alphaFactTypes.add(factType);
            } else {
                keyedFactTypes.add(factType);
            }
            typeMapping.putNew(builder, factType);
            for (FactType existing : this.groupFactTypes) {
                boolean sameAlpha;
                int sameKeys = existing.getFields().equals(factType.getFields()) ? 1 : 0;
                boolean bl = sameAlpha = existing.getBucketIndex() == factType.getBucketIndex();
                if (sameKeys == 0 || !sameAlpha) continue;
                existing.markNonUniqueKeyAndAlpha();
                factType.markNonUniqueKeyAndAlpha();
            }
            this.groupFactTypes.add(factType);
        }
        ConditionNodeDescriptor[] finalNodes = AbstractLhsDescriptor.findBestAllocation(compiledConditions, typeMapping);
        ArrayList<RhsFactGroupDescriptor> allFactGroups = new ArrayList<RhsFactGroupDescriptor>();
        int factGroupCounter = 0;
        int keyGroupIndex = 0;
        for (ConditionNodeDescriptor finalNode : finalNodes) {
            RhsFactGroupDescriptor descriptor = new RhsFactGroupDescriptor(this, factGroupCounter, keyGroupIndex, finalNode);
            allFactGroups.add(descriptor);
            ++factGroupCounter;
            ++keyGroupIndex;
            keyedFactTypes.removeAll(Arrays.asList(descriptor.getTypes()));
        }
        for (FactType keyedType : keyedFactTypes) {
            RhsFactGroupDescriptor descriptor = new RhsFactGroupDescriptor(this, factGroupCounter, keyGroupIndex, keyedType);
            allFactGroups.add(descriptor);
            ++factGroupCounter;
            ++keyGroupIndex;
        }
        if (!alphaFactTypes.isEmpty()) {
            allFactGroups.add(new RhsFactGroupDescriptor(this, factGroupCounter, alphaFactTypes));
        }
        for (RhsFactGroupDescriptor descriptor : allFactGroups) {
            FactType[] types = descriptor.getTypes();
            int factGroupIndex = descriptor.getFactGroupIndex();
            for (int i = 0; i < types.length; ++i) {
                this.nameIndices.putNew(types[i].getVar(), new int[]{factGroupIndex, i});
            }
        }
        this.allFactGroups = allFactGroups.toArray(RhsFactGroupDescriptor.ZERO_ARRAY);
    }

    private static ConditionNodeDescriptor[] findBestAllocation(AbstractLhsBuilder.Compiled lhsBuilder, MapFunction<NamedType, FactType> mapping) {
        HashSet<Evaluator> betaConditions = new HashSet<Evaluator>(lhsBuilder.getBetaConditions());
        if (betaConditions.isEmpty()) {
            return ConditionNodeDescriptor.ZERO_ARRAY;
        }
        ArrayList<EvaluatorGroup> evaluators = new ArrayList<EvaluatorGroup>(EvaluatorFactory.flattenEvaluators(betaConditions, mapping));
        if (evaluators.isEmpty()) {
            throw new IllegalStateException();
        }
        double maxComplexity = Double.MIN_VALUE;
        double minComplexity = Double.MAX_VALUE;
        HashSet<FactType> betaTypes = new HashSet<FactType>();
        for (EvaluatorGroup evaluatorGroup : evaluators) {
            double complexity = evaluatorGroup.getComplexity();
            if (complexity <= 0.0) {
                throw new IllegalStateException("Complexity must be a positive value");
            }
            if (complexity > maxComplexity) {
                maxComplexity = complexity;
            }
            if (complexity < minComplexity) {
                minComplexity = complexity;
            }
            betaTypes.addAll(evaluatorGroup.descriptor());
        }
        HashMap<EvaluatorGroup, Double> minMaxComplexities = new HashMap<EvaluatorGroup, Double>();
        for (EvaluatorGroup g : evaluators) {
            double newComplexity = 1.0 + (g.getComplexity() - minComplexity) / (maxComplexity - minComplexity);
            minMaxComplexities.put(g, newComplexity * (double)g.getEvaluators().length);
        }
        evaluators.sort((g1, g2) -> {
            int cmp = Double.compare((Double)minMaxComplexities.get(g1), (Double)minMaxComplexities.get(g2));
            if (cmp == 0) {
                cmp = g1.toString().compareTo(g2.toString());
            }
            return cmp;
        });
        Collection<ConditionNodeDescriptor> collection = ConditionNodeDescriptor.allocateConditions(betaTypes, evaluators);
        return collection.toArray(ConditionNodeDescriptor.ZERO_ARRAY);
    }

    MapFunction<String, int[]> getNameIndices() {
        return this.nameIndices;
    }

    RhsFactGroupDescriptor[] getAllFactGroups() {
        return this.allFactGroups;
    }

    public int getLevel() {
        return this.level;
    }

    public Set<FactType> getGroupFactTypes() {
        return this.groupFactTypes;
    }

    public String toString() {
        return "{factGroups=" + Arrays.toString(this.allFactGroups) + '}';
    }
}

