/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.evrete.api.NamedType;
import org.evrete.runtime.AbstractLhsDescriptor;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.AggregateLhsDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.builder.AggregateLhsBuilder;
import org.evrete.runtime.builder.LhsBuilder;
import org.evrete.util.MapFunction;
import org.evrete.util.NextIntSupplier;

public class LhsDescriptor
extends AbstractLhsDescriptor {
    private final Set<AggregateLhsDescriptor> aggregateDescriptors = new HashSet<AggregateLhsDescriptor>();
    private final MapFunction<NamedType, FactType> rootMapping;
    private final FactType[] allFactTypes;

    public LhsDescriptor(AbstractRuntime<?> runtime, LhsBuilder<?> root, NextIntSupplier factIdGenerator, MapFunction<NamedType, FactType> rootMapping) {
        super(runtime, null, root, factIdGenerator, rootMapping);
        HashSet<FactType> allFacts = new HashSet<FactType>(this.getGroupFactTypes());
        this.rootMapping = rootMapping;
        for (AggregateLhsBuilder<?> aggregateBuilder : root.getAggregateGroups()) {
            AggregateLhsDescriptor aggregateDescriptor = new AggregateLhsDescriptor(runtime, this, aggregateBuilder, factIdGenerator, new MapFunction<NamedType, FactType>());
            allFacts.addAll(aggregateDescriptor.getGroupFactTypes());
            this.aggregateDescriptors.add(aggregateDescriptor);
        }
        this.allFactTypes = new FactType[allFacts.size()];
        Iterator<AggregateLhsBuilder<Object>> iterator = allFacts.iterator();
        while (iterator.hasNext()) {
            FactType factType;
            this.allFactTypes[factType.getInRuleIndex()] = factType = (FactType)((Object)iterator.next());
        }
    }

    public FactType[] getAllFactTypes() {
        return this.allFactTypes;
    }

    public Set<AggregateLhsDescriptor> getAggregateDescriptors() {
        return this.aggregateDescriptors;
    }

    MapFunction<NamedType, FactType> getRootMapping() {
        return this.rootMapping;
    }
}

