/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.EnumMap;
import org.evrete.api.KeyMode;
import org.evrete.api.KeyReIterators;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.ValueRow;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.RuntimeFactTypeKeyed;
import org.evrete.runtime.memory.BetaEndNode;

public class RhsFactGroupBeta
implements RhsFactGroup,
KeyReIterators<ValueRow[]> {
    private final RuntimeFactTypeKeyed[] types;
    private final KeyReIterators<ValueRow[]> keyIterators;
    private final ValueRow[][] keyState;
    private final int groupIndex;
    private final RuntimeFact[] iterationState;
    private ValueRow[] currentKey;

    private RhsFactGroupBeta(RhsFactGroupDescriptor descriptor, RuntimeFactTypeKeyed[] types, KeyReIterators<ValueRow[]> keyIterators, ValueRow[][] keyState, RuntimeFact[][] factState) {
        this.types = types;
        this.keyIterators = keyIterators;
        this.keyState = keyState;
        this.groupIndex = descriptor.getFactGroupIndex();
        this.iterationState = factState[this.groupIndex];
    }

    public RhsFactGroupBeta(RhsFactGroupDescriptor descriptor, BetaEndNode endNode, ValueRow[][] keyState, RuntimeFact[][] factState) {
        this(descriptor, endNode.getEntryNodes(), endNode, keyState, factState);
    }

    public RhsFactGroupBeta(RhsFactGroupDescriptor descriptor, RuntimeFactTypeKeyed singleType, ValueRow[][] keyState, RuntimeFact[][] factState) {
        this(descriptor, new RuntimeFactTypeKeyed[]{singleType}, singleType.getMappedKeyIterators(), keyState, factState);
    }

    static void runCurrentFacts(RhsFactGroupBeta[] groups, Runnable r) {
        RhsFactGroupBeta.runCurrentFacts(0, groups.length - 1, groups, r);
    }

    private static void runCurrentFacts(int index, int lastIndex, RhsFactGroupBeta[] groups, Runnable r) {
        RhsFactGroupBeta group = groups[index];
        if (index == lastIndex) {
            group.runForEachFact(r);
        } else {
            int nextIndex = index + 1;
            Runnable nested = () -> RhsFactGroupBeta.runCurrentFacts(nextIndex, lastIndex, groups, r);
            group.runForEachFact(nested);
        }
    }

    boolean setKey(ValueRow[] key) {
        this.keyState[this.groupIndex] = key;
        this.currentKey = key;
        return true;
    }

    private void runForEachFact(Runnable r) {
        this.runForEachFact(0, this.currentKey.length, r);
    }

    private void runForEachFact(int index, int length, Runnable r) {
        ReIterator it = this.currentKey[index].iterator();
        if (index == length - 1) {
            while (it.hasNext()) {
                RuntimeFact fact = (RuntimeFact)it.next();
                if (fact.isDeleted()) {
                    it.remove();
                    continue;
                }
                this.iterationState[index] = fact;
                r.run();
            }
        } else {
            while (it.hasNext()) {
                RuntimeFact fact = (RuntimeFact)it.next();
                if (fact.isDeleted()) {
                    it.remove();
                    continue;
                }
                this.iterationState[index] = fact;
                this.runForEachFact(index + 1, length, r);
            }
        }
    }

    @Override
    public EnumMap<KeyMode, ReIterator<ValueRow[]>> keyIterators() {
        return this.keyIterators.keyIterators();
    }

    @Override
    public boolean isAlpha() {
        return false;
    }

    @Override
    public int getIndex() {
        return this.groupIndex;
    }

    public RuntimeFactTypeKeyed[] getTypes() {
        return this.types;
    }
}

