/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.api.KeyMode;
import org.evrete.api.KeyReIterators;
import org.evrete.api.Memory;
import org.evrete.api.SharedBetaFactStorage;
import org.evrete.api.ValueRow;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RuntimeFactType;
import org.evrete.runtime.memory.SessionMemory;
import org.evrete.util.ValueRowToArray;

public class RuntimeFactTypeKeyed
extends RuntimeFactType {
    private final SharedBetaFactStorage keyStorage;
    private final KeyReIterators<ValueRow> keyIterators;
    private final KeyReIterators<ValueRow[]> mappedKeyIterators;

    public RuntimeFactTypeKeyed(SessionMemory runtime, FactType other) {
        super(runtime, other);
        this.keyStorage = runtime.getBetaFactStorage(other);
        this.keyIterators = runtime.getBetaFactStorage(other).keyIterators();
        this.mappedKeyIterators = runtime.getBetaFactStorage(other).keyIterators(ValueRowToArray.SUPPLIER);
    }

    public RuntimeFactTypeKeyed(RuntimeFactTypeKeyed other) {
        super(other.getRuntime(), other);
        this.keyStorage = other.keyStorage;
        this.keyIterators = other.keyIterators;
        this.mappedKeyIterators = other.mappedKeyIterators;
    }

    @Override
    public Memory getSource() {
        return this.keyStorage;
    }

    @Override
    boolean isBetaNode() {
        return true;
    }

    public KeyReIterators<ValueRow> getKeyIterators() {
        return this.keyIterators;
    }

    public KeyReIterators<ValueRow[]> getMappedKeyIterators() {
        return this.mappedKeyIterators;
    }

    @Override
    public boolean isInsertDeltaAvailable() {
        return this.keyIterators.keyIterator(KeyMode.NEW_KEYS_NEW_FACTS).reset() > 0L || this.keyIterators.keyIterator(KeyMode.KNOWN_KEYS_NEW_FACTS).reset() > 0L;
    }
}

