/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.HashSet;
import java.util.Set;
import org.evrete.api.RuntimeRule;
import org.evrete.api.StatefulSession;
import org.evrete.api.Type;
import org.evrete.runtime.AbstractRuntimeRule;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeFactType;
import org.evrete.runtime.RuntimeLhs;
import org.evrete.runtime.memory.ActionQueue;
import org.evrete.runtime.memory.BetaEndNode;
import org.evrete.runtime.memory.SessionMemory;
import org.evrete.util.CollectionUtils;

public class RuntimeRuleImpl
extends AbstractRuntimeRule
implements RuntimeRule {
    private final RuntimeFactType[] factSources;
    private final SessionMemory memory;
    private final RuleDescriptor descriptor;
    private final RuntimeLhs lhs;
    private final Set<Type<?>> allTypes = new HashSet();
    private int rhsCallCounter = 0;

    public RuntimeRuleImpl(RuleDescriptor rd, SessionMemory memory) {
        super(memory, rd, rd.getLhs().getGroupFactTypes());
        this.descriptor = rd;
        this.memory = memory;
        FactType[] allFactTypes = this.descriptor.getLhs().getAllFactTypes();
        for (RuntimeFactType t : this.factSources = RuntimeRuleImpl.buildTypes(memory, allFactTypes)) {
            this.allTypes.add(t.getType());
        }
        this.lhs = RuntimeLhs.factory(this, rd.getLhs());
    }

    private static RuntimeFactType[] buildTypes(SessionMemory runtime, FactType[] allFactTypes) {
        RuntimeFactType[] factSources = new RuntimeFactType[allFactTypes.length];
        for (FactType factType : allFactTypes) {
            RuntimeFactType iterable;
            factSources[iterable.getInRuleIndex()] = iterable = RuntimeFactType.factory(factType, runtime);
        }
        return factSources;
    }

    public void mergeNodeDeltas() {
        for (BetaEndNode endNode : this.lhs.getAllBetaEndNodes()) {
            endNode.mergeDelta();
        }
    }

    public boolean dependsOn(Type<?> type) {
        return this.allTypes.contains(type);
    }

    public final int executeRhs(ActionQueue<Object> destinationBuffer) {
        this.rhsCallCounter = 0;
        this.lhs.setBuffer(destinationBuffer);
        this.lhs.forEach(this.rhs.andThen(rhsContext -> this.increaseCallCount()));
        return this.rhsCallCounter;
    }

    private void increaseCallCount() {
        ++this.rhsCallCounter;
    }

    public void clear() {
        for (BetaEndNode endNode : this.lhs.getAllBetaEndNodes()) {
            endNode.clear();
        }
    }

    @Override
    public RuntimeRule set(String property, Object value) {
        super.set(property, value);
        return this;
    }

    public <T extends RuntimeFactType> T resolve(FactType type) {
        return (T)this.factSources[type.getInRuleIndex()];
    }

    public <Z extends RuntimeFactType> Z[] resolve(Class<Z> type, FactType[] types) {
        RuntimeFactType[] resolved = (RuntimeFactType[])CollectionUtils.array(type, types.length);
        for (int i = 0; i < types.length; ++i) {
            resolved[i] = this.resolve(types[i]);
        }
        return resolved;
    }

    public RuntimeFactType[] getAllFactTypes() {
        return this.factSources;
    }

    public RuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public SessionMemory getMemory() {
        return this.memory;
    }

    @Override
    public StatefulSession getRuntime() {
        return (StatefulSession)((Object)this.memory);
    }

    @Override
    public RuntimeRule addImport(String imp) {
        super.addImport(imp);
        return this;
    }

    public RuntimeLhs getLhs() {
        return this.lhs;
    }

    public String toString() {
        return "RuntimeRule{name=" + this.getName() + '}';
    }
}

