/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.List;
import java.util.function.BooleanSupplier;
import org.evrete.api.Action;
import org.evrete.api.ActivationManager;
import org.evrete.api.EvaluationListener;
import org.evrete.api.Named;
import org.evrete.api.RuntimeRule;
import org.evrete.api.StatefulSession;
import org.evrete.runtime.ActivationContext;
import org.evrete.runtime.KnowledgeImpl;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.memory.ActionQueue;
import org.evrete.runtime.memory.SessionMemory;
import org.evrete.runtime.memory.TypeMemory;

public class StatefulSessionImpl
extends SessionMemory
implements StatefulSession {
    private final KnowledgeImpl knowledge;
    private ActivationManager activationManager;
    private BooleanSupplier fireCriteria = () -> true;

    StatefulSessionImpl(KnowledgeImpl knowledge) {
        super(knowledge);
        this.knowledge = knowledge;
        this.activationManager = this.newActivationManager();
    }

    @Override
    public RuntimeRule getRule(String name) {
        return Named.find(this.getRules(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StatefulSessionImpl statefulSessionImpl = this;
        synchronized (statefulSessionImpl) {
            this.invalidateSession();
            super.destroy();
            this.knowledge.close(this);
        }
    }

    @Override
    public StatefulSession addImport(String imp) {
        super.addImport(imp);
        return this;
    }

    @Override
    public StatefulSession addImport(Class<?> type) {
        super.addImport(type);
        return this;
    }

    @Override
    public ActivationManager getActivationManager() {
        return this.activationManager;
    }

    @Override
    public StatefulSession setActivationManager(ActivationManager activationManager) {
        this.activationManager = activationManager;
        return this;
    }

    @Override
    public <A extends ActivationManager> void setActivationManagerFactory(Class<A> managerClass) {
        super.setActivationManagerFactory(managerClass);
        this.activationManager = this.newActivationManager();
    }

    @Override
    public StatefulSession setFireCriteria(BooleanSupplier fireCriteria) {
        this.fireCriteria = fireCriteria;
        return this;
    }

    @Override
    public void fire() {
        switch (this.getAgendaMode()) {
            case DEFAULT: {
                this.fireDefault(new ActivationContext(this));
                break;
            }
            case CONTINUOUS: {
                this.fireContinuous(new ActivationContext(this));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode " + (Object)((Object)this.getAgendaMode()));
            }
        }
    }

    private void fireContinuous(ActivationContext ctx) {
        ActionQueue<Object> memoryActions = new ActionQueue<Object>();
        while (this.fireCriteria.getAsBoolean() && this.hasActions(Action.INSERT, Action.RETRACT)) {
            this._assertActive();
            this.doDeletions();
            List<RuntimeRule> agenda = this.propagateInsertChanges();
            if (agenda.isEmpty()) continue;
            this.activationManager.onAgenda(ctx.incrementFireCount(), agenda);
            memoryActions.clear();
            for (RuntimeRule candidate : agenda) {
                RuntimeRuleImpl rule = (RuntimeRuleImpl)candidate;
                if (!this.activationManager.test(candidate) || rule.executeRhs(memoryActions) <= 0) continue;
                this.activationManager.onActivation(rule);
            }
            this.commitInserts();
            this.appendToBuffer(memoryActions);
        }
    }

    private void fireDefault(ActivationContext ctx) {
        ActionQueue<Object> memoryActions = new ActionQueue<Object>();
        while (this.fireCriteria.getAsBoolean() && this.hasActions(Action.INSERT, Action.RETRACT)) {
            this._assertActive();
            this.doDeletions();
            List<RuntimeRule> agenda = this.propagateInsertChanges();
            if (agenda.isEmpty()) continue;
            this.activationManager.onAgenda(ctx.incrementFireCount(), agenda);
            memoryActions.clear();
            for (RuntimeRule candidate : agenda) {
                RuntimeRuleImpl rule = (RuntimeRuleImpl)candidate;
                if (!this.activationManager.test(candidate) || rule.executeRhs(memoryActions) <= 0) continue;
                this.activationManager.onActivation(rule);
                this.appendToBuffer(memoryActions);
                memoryActions.clear();
                this.doDeletions();
                if (!this.hasActions(Action.INSERT)) continue;
                break;
            }
            this.commitInserts();
        }
    }

    private void commitInserts() {
        this.typeMemories().forEachRemaining(TypeMemory::commitDeltas);
    }

    @Override
    public void addConditionTestListener(EvaluationListener listener) {
        throw new UnsupportedOperationException("Currently unsupported for session instances, use knowledge instances instead.");
    }
}

