/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.evrete.api.Evaluator;
import org.evrete.api.FactBuilder;
import org.evrete.api.NamedType;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.TypeResolver;
import org.evrete.api.ValuesPredicate;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.builder.AbstractExpression;
import org.evrete.runtime.builder.FactTypeBuilder;
import org.evrete.runtime.builder.FieldReference;
import org.evrete.runtime.builder.PredicateExpression0;
import org.evrete.runtime.builder.PredicateExpression1;
import org.evrete.runtime.builder.PredicateExpression2;
import org.evrete.runtime.builder.PredicateExpression3;
import org.evrete.runtime.builder.PredicateExpression4;
import org.evrete.runtime.builder.RuleBuilderImpl;
import org.evrete.util.MapOfSet;

public abstract class AbstractLhsBuilder<C extends RuntimeContext<C>, G extends AbstractLhsBuilder<C, ?>> {
    private final RuleBuilderImpl<C> ruleBuilder;
    private final Map<String, FactTypeBuilder> declaredLhsTypes;
    private final Set<AbstractExpression> conditions = new HashSet<AbstractExpression>();
    private final Function<String, FactTypeBuilder> factTypeMapper;
    private Compiled compiledData;

    private AbstractLhsBuilder(RuleBuilderImpl<C> ruleBuilder, final AbstractLhsBuilder<C, ?> parent) {
        this.ruleBuilder = ruleBuilder;
        this.declaredLhsTypes = new HashMap<String, FactTypeBuilder>();
        this.factTypeMapper = new Function<String, FactTypeBuilder>(){

            @Override
            public FactTypeBuilder apply(String s) {
                FactTypeBuilder found = (FactTypeBuilder)AbstractLhsBuilder.this.declaredLhsTypes.get(s);
                if (found == null && parent != null) {
                    found = (FactTypeBuilder)parent.factTypeMapper.apply(s);
                }
                return found;
            }
        };
    }

    AbstractLhsBuilder(RuleBuilderImpl<C> ruleBuilder) {
        this(ruleBuilder, null);
    }

    AbstractLhsBuilder(AbstractLhsBuilder<C, ?> parent) {
        this(parent.ruleBuilder, parent);
    }

    protected abstract G self();

    private TypeResolver getTypeResolver() {
        return this.ruleBuilder.getRuntimeContext().getTypeResolver();
    }

    public Compiled getCompiledData() {
        if (this.compiledData == null) {
            throw new IllegalStateException("Conditions not compiled");
        }
        return this.compiledData;
    }

    public Function<String, NamedType> getFactTypeMapper() {
        return this.factTypeMapper::apply;
    }

    public void compileConditions(AbstractRuntime<?> runtime) {
        if (this.compiledData != null) {
            throw new IllegalStateException("Conditions already compiled");
        }
        this.compiledData = new Compiled(runtime, this);
    }

    private AbstractLhsBuilder<?, ?> locateLhsGroup(NamedType type) {
        FactTypeBuilder builder = this.factTypeMapper.apply(type.getVar());
        if (builder == null) {
            throw new IllegalStateException();
        }
        return builder.getGroup();
    }

    public Set<FactTypeBuilder> getDeclaredFactTypes() {
        return new HashSet<FactTypeBuilder>(this.declaredLhsTypes.values());
    }

    RuleBuilderImpl<C> getRuleBuilder() {
        return this.ruleBuilder;
    }

    public G where(String ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this.self();
        }
        for (String expression : expressions) {
            this.addExpression(expression);
        }
        return this.self();
    }

    public G where(String expression, double complexity) {
        this.addExpression(expression, complexity);
        return this.self();
    }

    public G where(Predicate<Object[]> predicate, double complexity, String ... references) {
        this.addExpression(predicate, complexity, references);
        return this.self();
    }

    public G where(Predicate<Object[]> predicate, String ... references) {
        this.addExpression(predicate, references);
        return this.self();
    }

    public G where(ValuesPredicate predicate, double complexity, String ... references) {
        this.addExpression(predicate, complexity, references);
        return this.self();
    }

    public G where(ValuesPredicate predicate, String ... references) {
        this.addExpression(predicate, references);
        return this.self();
    }

    public G where(Predicate<Object[]> predicate, double complexity, FieldReference ... references) {
        this.addExpression(predicate, complexity, references);
        return this.self();
    }

    public G where(Predicate<Object[]> predicate, FieldReference ... references) {
        this.addExpression(predicate, references);
        return this.self();
    }

    public G where(ValuesPredicate predicate, double complexity, FieldReference ... references) {
        this.addExpression(predicate, complexity, references);
        return this.self();
    }

    public G where(ValuesPredicate predicate, FieldReference ... references) {
        this.addExpression(predicate, references);
        return this.self();
    }

    private void addExpression(String expression, double complexity) {
        this.conditions.add(new PredicateExpression0(expression, complexity));
    }

    private void addExpression(Predicate<Object[]> predicate, double complexity, String[] references) {
        this.conditions.add(new PredicateExpression2(predicate, complexity, references));
    }

    private void addExpression(Predicate<Object[]> predicate, String[] references) {
        this.conditions.add(new PredicateExpression2(predicate, references));
    }

    private void addExpression(ValuesPredicate predicate, double complexity, String[] references) {
        this.conditions.add(new PredicateExpression1(predicate, complexity, references));
    }

    private void addExpression(ValuesPredicate predicate, String[] references) {
        this.conditions.add(new PredicateExpression1(predicate, references));
    }

    private void addExpression(Predicate<Object[]> predicate, double complexity, FieldReference[] references) {
        this.conditions.add(new PredicateExpression3(predicate, complexity, references));
    }

    private void addExpression(Predicate<Object[]> predicate, FieldReference[] references) {
        this.conditions.add(new PredicateExpression3(predicate, references));
    }

    private void addExpression(ValuesPredicate predicate, double complexity, FieldReference[] references) {
        this.conditions.add(new PredicateExpression4(predicate, complexity, references));
    }

    private void addExpression(ValuesPredicate predicate, FieldReference[] references) {
        this.conditions.add(new PredicateExpression4(predicate, references));
    }

    private void addExpression(String expression) {
        this.conditions.add(new PredicateExpression0(expression));
    }

    public synchronized FactTypeBuilder buildLhs(String name, Type<?> type) {
        this.checkRefName(name);
        FactTypeBuilder factType = new FactTypeBuilder(this, name, type);
        this.declaredLhsTypes.put(name, factType);
        return factType;
    }

    public FactTypeBuilder buildLhs(String name, String type) {
        return this.buildLhs(name, this.getTypeResolver().getOrDeclare(type));
    }

    G buildLhs(Collection<FactBuilder> facts) {
        if (facts == null || facts.isEmpty()) {
            return this.self();
        }
        for (FactBuilder f : facts) {
            this.buildLhs(f.getName(), f.getType());
        }
        return this.self();
    }

    public FactTypeBuilder buildLhs(String name, Class<?> type) {
        return this.buildLhs(name, type.getName());
    }

    private void checkRefName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Null or empty type reference in " + this.ruleBuilder);
        }
        if (this.declaredLhsTypes.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate type reference '" + name + "' in rule " + this.ruleBuilder);
        }
    }

    public static class Compiled {
        private static final Set<Evaluator> EMPTY_ALPHA_CONDITIONS = new HashSet<Evaluator>();
        private final Set<Evaluator> betaConditions = new HashSet<Evaluator>();
        private final MapOfSet<NamedType, Evaluator> alphaConditions = new MapOfSet();
        private final Set<Evaluator> aggregateConditions = new HashSet<Evaluator>();
        private final AbstractLhsBuilder<?, ?> lhsBuilder;

        Compiled(AbstractRuntime<?> runtime, AbstractLhsBuilder<?, ?> lhsBuilder) {
            this.lhsBuilder = lhsBuilder;
            for (AbstractExpression condition : ((AbstractLhsBuilder)lhsBuilder).conditions) {
                Evaluator evaluator = condition.build(runtime, lhsBuilder.getFactTypeMapper());
                this.addCondition(evaluator);
            }
        }

        private void addCondition(Evaluator expression) {
            FieldReference[] descriptor = expression.descriptor();
            if (descriptor.length == 1) {
                NamedType type = descriptor[0].type();
                this.alphaConditions.add(type, expression);
            } else {
                HashSet<AbstractLhsBuilder> involvedGroups = new HashSet<AbstractLhsBuilder>();
                for (FieldReference ref : descriptor) {
                    FactTypeBuilder factTypeBuilder = (FactTypeBuilder)((AbstractLhsBuilder)this.lhsBuilder).factTypeMapper.apply(ref.type().getVar());
                    factTypeBuilder.addBetaField(ref);
                    AbstractLhsBuilder refBuilder = ((AbstractLhsBuilder)this.lhsBuilder).locateLhsGroup(ref.type());
                    involvedGroups.add(refBuilder);
                }
                if (!involvedGroups.contains(this.lhsBuilder)) {
                    throw new IllegalStateException("Aggregate group contains external condition: " + expression);
                }
                if (involvedGroups.size() == 1) {
                    this.betaConditions.add(expression);
                } else {
                    for (FieldReference ref : expression.descriptor()) {
                        AbstractLhsBuilder group = ((AbstractLhsBuilder)this.lhsBuilder).locateLhsGroup(ref.type());
                        if (group != this.lhsBuilder) continue;
                        this.aggregateConditions.add(expression);
                    }
                }
            }
        }

        public Set<Evaluator> getAlphaConditions(FactTypeBuilder builder) {
            return this.alphaConditions.getOrDefault(builder, (Evaluator)((Object)EMPTY_ALPHA_CONDITIONS));
        }

        public Set<Evaluator> getBetaConditions() {
            return this.betaConditions;
        }

        public Set<Evaluator> getAggregateConditions() {
            return this.aggregateConditions;
        }
    }
}

