/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.evrete.api.Copyable;
import org.evrete.api.Evaluator;
import org.evrete.api.FieldsKey;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.evaluation.AlphaDelta;
import org.evrete.runtime.evaluation.AlphaEvaluator;

public class AlphaConditions
implements Copyable<AlphaConditions> {
    private static final ArrayOf<AlphaEvaluator> EMPTY = new ArrayOf<AlphaEvaluator>(new AlphaEvaluator[0]);
    private final Map<Type<?>, ArrayOf<AlphaEvaluator>> alphaPredicates;
    private final Map<Type<?>, TypeAlphas> typeAlphas;

    private AlphaConditions(AlphaConditions other) {
        this.alphaPredicates = new HashMap();
        for (Map.Entry<Type<?>, ArrayOf<AlphaEvaluator>> entry : other.alphaPredicates.entrySet()) {
            this.alphaPredicates.put(entry.getKey(), new ArrayOf<AlphaEvaluator>(entry.getValue()));
        }
        this.typeAlphas = new HashMap();
        other.typeAlphas.forEach((fields, alphas) -> this.typeAlphas.put((Type<?>)fields, alphas.copyOf()));
    }

    public AlphaConditions() {
        this.typeAlphas = new HashMap();
        this.alphaPredicates = new HashMap();
    }

    @Override
    public AlphaConditions copyOf() {
        return new AlphaConditions(this);
    }

    public int size(Type<?> type) {
        return ((AlphaEvaluator[])this.alphaPredicates.getOrDefault(type, AlphaConditions.EMPTY).data).length;
    }

    public synchronized AlphaBucketMeta register(AbstractRuntime<?> runtime, FieldsKey betaFields, boolean beta, Set<Evaluator> typePredicates, Consumer<AlphaDelta> listener) {
        if (typePredicates.isEmpty() && betaFields.size() == 0) {
            return AlphaBucketMeta.NO_FIELDS_NO_CONDITIONS;
        }
        LinkedList newEvaluators = new LinkedList();
        Type<?> type = betaFields.getType();
        AlphaMeta candidate = this.createAlphaMask(runtime, type, typePredicates, newEvaluators::add);
        return this.typeAlphas.computeIfAbsent(type, TypeAlphas::new).getCreate(betaFields, beta, candidate, alphaBucketMeta -> listener.accept(new AlphaDelta(betaFields, (AlphaBucketMeta)alphaBucketMeta, newEvaluators)));
    }

    public ArrayOf<AlphaEvaluator> getPredicates(Type<?> t) {
        return this.alphaPredicates.getOrDefault(t, EMPTY);
    }

    public String toString() {
        return "AlphaConditions{alphaPredicates=" + this.alphaPredicates + '}';
    }

    private AlphaMeta createAlphaMask(AbstractRuntime<?> runtime, Type<?> t, Set<Evaluator> typePredicates, Consumer<AlphaEvaluator> listener) {
        ArrayOf existing = this.alphaPredicates.computeIfAbsent(t, k -> new ArrayOf<AlphaEvaluator>(new AlphaEvaluator[0]));
        LinkedList<EvaluationSide> mapping = new LinkedList<EvaluationSide>();
        for (Evaluator alphaPredicate : typePredicates) {
            AlphaEvaluator found = null;
            boolean foundDirect = true;
            block6: for (AlphaEvaluator ia : (AlphaEvaluator[])existing.data) {
                int cmp = alphaPredicate.compare(ia.getDelegate());
                switch (cmp) {
                    case 1: {
                        found = ia;
                        foundDirect = true;
                        continue block6;
                    }
                    case -1: {
                        found = ia;
                        foundDirect = false;
                        continue block6;
                    }
                    case 0: {
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (found == null) {
                TypeField field = alphaPredicate.descriptor()[0].field();
                found = new AlphaEvaluator(((AlphaEvaluator[])existing.data).length, alphaPredicate, runtime.getCreateActiveField(field));
                existing.append(found);
                listener.accept(found);
            }
            mapping.add(new EvaluationSide(found, foundDirect));
        }
        boolean[] validValues = new boolean[((AlphaEvaluator[])existing.data).length];
        AlphaEvaluator[] alphaEvaluators = new AlphaEvaluator[mapping.size()];
        int mappingIdx = 0;
        for (EvaluationSide h : mapping) {
            int alphaId = h.condition.getUniqueId();
            alphaEvaluators[mappingIdx] = h.condition;
            validValues[alphaId] = h.direct;
            ++mappingIdx;
        }
        Arrays.sort(alphaEvaluators, Comparator.comparingInt(AlphaEvaluator::getUniqueId));
        return new AlphaMeta(validValues, alphaEvaluators);
    }

    private static class AlphaMeta {
        private final AlphaEvaluator[] alphaEvaluators;
        private final boolean[] requiredValues;

        AlphaMeta(boolean[] requiredValues, AlphaEvaluator[] alphaEvaluators) {
            this.requiredValues = requiredValues;
            this.alphaEvaluators = alphaEvaluators;
        }
    }

    private static class TypeAlphas
    implements Copyable<TypeAlphas> {
        private final Map<FieldsKey, FieldAlphas> dataAlpha = new HashMap<FieldsKey, FieldAlphas>();
        private final Map<FieldsKey, FieldAlphas> dataBeta = new HashMap<FieldsKey, FieldAlphas>();

        TypeAlphas(Type<?> type) {
        }

        TypeAlphas(TypeAlphas other) {
            this.dataAlpha.putAll(other.dataAlpha);
            this.dataBeta.putAll(other.dataBeta);
        }

        private AlphaBucketMeta getCreate(FieldsKey betaFields, boolean beta, AlphaMeta candidate, Consumer<AlphaBucketMeta> listener) {
            Map<FieldsKey, FieldAlphas> map = beta ? this.dataBeta : this.dataAlpha;
            return map.computeIfAbsent(betaFields, FieldAlphas::new).getCreate(candidate, listener);
        }

        @Override
        public TypeAlphas copyOf() {
            return new TypeAlphas(this);
        }
    }

    private static class EvaluationSide {
        private final AlphaEvaluator condition;
        private final boolean direct;

        EvaluationSide(AlphaEvaluator condition, boolean direct) {
            this.condition = condition;
            this.direct = direct;
        }
    }

    private static class FieldAlphas
    implements Copyable<FieldAlphas> {
        private final ArrayOf<AlphaBucketMeta> data;

        FieldAlphas(FieldsKey fields) {
            this.data = fields.size() == 0 ? new ArrayOf<AlphaBucketMeta>(new AlphaBucketMeta[]{AlphaBucketMeta.NO_FIELDS_NO_CONDITIONS}) : new ArrayOf<AlphaBucketMeta>(new AlphaBucketMeta[0]);
        }

        FieldAlphas(FieldAlphas other) {
            this.data = new ArrayOf<AlphaBucketMeta>(other.data);
        }

        AlphaBucketMeta getCreate(AlphaMeta candidate, Consumer<AlphaBucketMeta> listener) {
            AlphaBucketMeta found = null;
            for (AlphaBucketMeta mask : (AlphaBucketMeta[])this.data.data) {
                if (!mask.sameData(candidate.alphaEvaluators, candidate.requiredValues)) continue;
                found = mask;
                break;
            }
            if (found == null) {
                found = AlphaBucketMeta.factory(((AlphaBucketMeta[])this.data.data).length, candidate.alphaEvaluators, candidate.requiredValues);
                this.data.append(found);
                listener.accept(found);
            }
            return found;
        }

        @Override
        public FieldAlphas copyOf() {
            return new FieldAlphas(this);
        }
    }
}

