/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import org.evrete.api.KeyMode;
import org.evrete.api.KeyReIterators;
import org.evrete.api.KeysStore;
import org.evrete.api.ReIterator;
import org.evrete.api.Type;
import org.evrete.api.ValueRow;
import org.evrete.collections.CollectionReIterator;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.EntryNodeDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.NodeDescriptor;
import org.evrete.runtime.RhsKeyIterator;
import org.evrete.runtime.RuntimeFactTypeKeyed;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.memory.BetaConditionNode;
import org.evrete.runtime.memory.BetaEntryNode;
import org.evrete.runtime.memory.BetaMemoryNode;

public class BetaEndNode
extends BetaConditionNode
implements KeyReIterators<ValueRow[]> {
    private final List<ValueRow[]> oldKeysNewFacts;
    private final EnumMap<KeyMode, ReIterator<ValueRow[]>> keyIterators = new EnumMap(KeyMode.class);
    private final RuntimeFactTypeKeyed[] entryNodes;

    public BetaEndNode(RuntimeRuleImpl rule, ConditionNodeDescriptor nodeDescriptor) {
        super(rule, nodeDescriptor, BetaEndNode.create(nodeDescriptor.getSources(), rule));
        FactType[] factTypes = nodeDescriptor.getEvalGrouping()[0];
        assert (factTypes.length == nodeDescriptor.getTypes().length);
        this.oldKeysNewFacts = new LinkedList<ValueRow[]>();
        for (KeyMode mode : KeyMode.values()) {
            ModeIteratorDelegate modeIterator;
            switch (mode) {
                case NEW_KEYS_NEW_FACTS: {
                    modeIterator = new ModeIteratorDelegate(mode, this.deltaIterator());
                    break;
                }
                case KNOWN_KEYS_KNOWN_FACTS: {
                    modeIterator = new ModeIteratorDelegate(mode, this.mainIterator());
                    break;
                }
                case KNOWN_KEYS_NEW_FACTS: {
                    CollectionReIterator<ValueRow[]> listReIterator = new CollectionReIterator<ValueRow[]>(this.oldKeysNewFacts);
                    modeIterator = new ModeIteratorDelegate(mode, listReIterator);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.keyIterators.put(mode, modeIterator);
        }
        this.entryNodes = this.getEntryNodes();
    }

    private static BetaMemoryNode<?>[] create(NodeDescriptor[] sources, RuntimeRuleImpl rule) {
        BetaMemoryNode[] result = new BetaMemoryNode[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            result[i] = BetaEndNode.create(rule, sources[i]);
        }
        return result;
    }

    public boolean dependsOn(Type<?> type) {
        for (RuntimeFactTypeKeyed entry : this.entryNodes) {
            if (!entry.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    private static BetaMemoryNode<?> create(RuntimeRuleImpl rule, NodeDescriptor desc) {
        if (desc.isConditionNode()) {
            return new BetaConditionNode(rule, (ConditionNodeDescriptor)desc, BetaEndNode.create(desc.getSources(), rule));
        }
        EntryNodeDescriptor descriptor = (EntryNodeDescriptor)desc;
        return new BetaEntryNode(descriptor, (RuntimeFactTypeKeyed)rule.resolve(descriptor.getFactType()));
    }

    @Override
    public void computeDelta(boolean deltaOnly) {
        super.computeDelta(deltaOnly);
        ReIterator<KeysStore.Entry> deleteIterator = this.getMainStore().entries();
        if (deleteIterator.reset() > 0L) {
            while (deleteIterator.hasNext()) {
                if (BetaEndNode.isEntryNonDeleted((KeysStore.Entry)deleteIterator.next())) continue;
                deleteIterator.remove();
            }
        }
        if (deltaOnly) {
            ValueRow[] array = new ValueRow[this.entryNodes.length];
            this.oldKeysNewFacts.clear();
            this.computeOldKeysNewFacts(0, false, array);
        }
    }

    private void computeOldKeysNewFacts(int index, boolean oldKeysNewFactsPresent, ValueRow[] array) {
        block12: {
            ReIterator<ValueRow> newKeysNewFacts;
            ReIterator<ValueRow> knownKeysNewFacts;
            ReIterator<ValueRow> knownKeysKnownFacts;
            block11: {
                KeyReIterators<ValueRow> entry = this.entryNodes[index].getKeyIterators();
                knownKeysKnownFacts = entry.keyIterator(KeyMode.KNOWN_KEYS_KNOWN_FACTS);
                knownKeysNewFacts = entry.keyIterator(KeyMode.KNOWN_KEYS_NEW_FACTS);
                newKeysNewFacts = entry.keyIterator(KeyMode.NEW_KEYS_NEW_FACTS);
                if (index != this.entryNodes.length - 1) break block11;
                ReIterator<ValueRow> it = knownKeysNewFacts;
                if (it.reset() > 0L) {
                    while (it.hasNext()) {
                        array[index] = (ValueRow)it.next();
                        this.testAndSave(array);
                    }
                }
                it = knownKeysKnownFacts;
                if (oldKeysNewFactsPresent && it.reset() > 0L) {
                    while (it.hasNext()) {
                        array[index] = (ValueRow)it.next();
                        this.testAndSave(array);
                    }
                }
                it = newKeysNewFacts;
                if (!oldKeysNewFactsPresent || it.reset() <= 0L) break block12;
                while (it.hasNext()) {
                    array[index] = (ValueRow)it.next();
                    this.testAndSave(array);
                }
                break block12;
            }
            ReIterator<ValueRow> it = knownKeysNewFacts;
            if (it.reset() > 0L) {
                while (it.hasNext()) {
                    array[index] = (ValueRow)it.next();
                    this.computeOldKeysNewFacts(index + 1, true, array);
                }
            }
            if ((it = knownKeysKnownFacts).reset() > 0L) {
                while (it.hasNext()) {
                    array[index] = (ValueRow)it.next();
                    this.computeOldKeysNewFacts(index + 1, oldKeysNewFactsPresent, array);
                }
            }
            if ((it = newKeysNewFacts).reset() > 0L) {
                while (it.hasNext()) {
                    array[index] = (ValueRow)it.next();
                    this.computeOldKeysNewFacts(index + 1, oldKeysNewFactsPresent, array);
                }
            }
        }
    }

    private void testAndSave(ValueRow[] array) {
        KeysStore main = this.getMainStore();
        KeysStore delta = this.getDeltaStore();
        if (main.hasKey(value -> array[value]) || delta.hasKey(value -> array[value])) {
            this.oldKeysNewFacts.add(Arrays.copyOf(array, array.length));
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.oldKeysNewFacts.clear();
    }

    @Override
    public EnumMap<KeyMode, ReIterator<ValueRow[]>> keyIterators() {
        return this.keyIterators;
    }

    public RuntimeFactTypeKeyed[] getEntryNodes() {
        return this.getGrouping()[0];
    }

    private static class ModeIteratorDelegate
    extends ModeIterator {
        private final ReIterator<ValueRow[]> delegate;

        public ModeIteratorDelegate(KeyMode mode, ReIterator<ValueRow[]> delegate) {
            super(mode);
            this.delegate = delegate;
        }

        @Override
        public long reset() {
            return this.delegate.reset();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public ValueRow[] next() {
            return (ValueRow[])this.delegate.next();
        }
    }

    private static abstract class ModeIterator
    implements RhsKeyIterator {
        private final KeyMode mode;

        public ModeIterator(KeyMode mode) {
            this.mode = mode;
        }

        @Override
        public final KeyMode getMode() {
            return this.mode;
        }
    }
}

