/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import org.evrete.api.FieldsKey;
import org.evrete.api.Memory;
import org.evrete.api.ReIterable;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.SharedBetaFactStorage;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.memory.FieldsMemoryBucket;
import org.evrete.runtime.memory.SessionMemory;

public class FieldsMemory
implements Memory {
    private final FieldsKey typeFields;
    private final SessionMemory runtime;
    private final ArrayOf<FieldsMemoryBucket> alphaBuckets;

    FieldsMemory(SessionMemory runtime, FieldsKey typeFields) {
        this.runtime = runtime;
        this.typeFields = typeFields;
        this.alphaBuckets = new ArrayOf<FieldsMemoryBucket>(FieldsMemoryBucket.class);
    }

    public SharedBetaFactStorage get(AlphaBucketMeta mask) {
        int bucketIndex = mask.getBucketIndex();
        if (bucketIndex >= ((FieldsMemoryBucket[])this.alphaBuckets.data).length) {
            throw new IllegalArgumentException("No alpha bucket created for " + mask);
        }
        SharedBetaFactStorage storage = ((FieldsMemoryBucket[])this.alphaBuckets.data)[bucketIndex].getFieldData();
        if (storage == null) {
            throw new IllegalArgumentException("No alpha bucket created for " + mask);
        }
        return storage;
    }

    @Override
    public void commitChanges() {
        for (FieldsMemoryBucket bucket : (FieldsMemoryBucket[])this.alphaBuckets.data) {
            bucket.commitChanges();
        }
    }

    public void commitDeltas() {
        for (FieldsMemoryBucket bucket : (FieldsMemoryBucket[])this.alphaBuckets.data) {
            bucket.commitChanges();
        }
    }

    FieldsMemoryBucket touchMemory(AlphaBucketMeta alphaMeta) {
        int bucketIndex = alphaMeta.getBucketIndex();
        if (this.alphaBuckets.isEmptyAt(bucketIndex)) {
            FieldsMemoryBucket newBucket = new FieldsMemoryBucket(this.runtime, this.typeFields, alphaMeta);
            this.alphaBuckets.set(bucketIndex, newBucket);
            return newBucket;
        }
        return null;
    }

    <T extends RuntimeFact> void onNewAlphaBucket(AlphaBucketMeta alphaMeta, ReIterator<T> existingFacts) {
        FieldsMemoryBucket newBucket = this.touchMemory(alphaMeta);
        assert (newBucket != null);
        if (existingFacts.reset() > 0L) {
            while (existingFacts.hasNext()) {
                RuntimeFact rto = (RuntimeFact)existingFacts.next();
                if (!alphaMeta.test(rto)) continue;
                throw new UnsupportedOperationException();
            }
        }
    }

    void clear() {
        for (FieldsMemoryBucket bucket : (FieldsMemoryBucket[])this.alphaBuckets.data) {
            bucket.clear();
        }
    }

    void insert(ReIterable<? extends RuntimeFact> facts) {
        for (FieldsMemoryBucket bucket : (FieldsMemoryBucket[])this.alphaBuckets.data) {
            bucket.insert(facts);
        }
    }

    public void retract(ReIterable<? extends RuntimeFact> facts) {
        for (FieldsMemoryBucket bucket : (FieldsMemoryBucket[])this.alphaBuckets.data) {
            bucket.delete(facts);
        }
    }

    public String toString() {
        return this.alphaBuckets.toString();
    }
}

