/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import org.evrete.api.Action;
import org.evrete.api.ActiveField;
import org.evrete.api.FieldsKey;
import org.evrete.api.ReIterator;
import org.evrete.api.Rule;
import org.evrete.api.RuntimeContext;
import org.evrete.api.RuntimeFact;
import org.evrete.api.RuntimeRule;
import org.evrete.api.SharedBetaFactStorage;
import org.evrete.api.StatefulSession;
import org.evrete.api.Type;
import org.evrete.api.TypeResolver;
import org.evrete.api.WorkingMemory;
import org.evrete.collections.AbstractLinearHashMap;
import org.evrete.collections.LinearHashMap;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.FactType;
import org.evrete.runtime.KnowledgeImpl;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.RuntimeRules;
import org.evrete.runtime.async.Completer;
import org.evrete.runtime.async.ForkJoinExecutor;
import org.evrete.runtime.async.RuleHotDeploymentTask;
import org.evrete.runtime.async.RuleMemoryInsertTask;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.evaluation.AlphaDelta;
import org.evrete.runtime.memory.ActionCounter;
import org.evrete.runtime.memory.ActionQueue;
import org.evrete.runtime.memory.BetaEndNode;
import org.evrete.runtime.memory.TypeMemory;

public class SessionMemory
extends AbstractRuntime<StatefulSession>
implements WorkingMemory,
Iterable<TypeMemory> {
    private static final Logger LOGGER = Logger.getLogger(SessionMemory.class.getName());
    private final RuntimeRules ruleStorage;
    private final LinearHashMap<Type<?>, TypeMemory> typedMemories;
    private static final Function<AbstractLinearHashMap.Entry<Type<?>, TypeMemory>, TypeMemory> TYPE_MEMORY_MAPPING = AbstractLinearHashMap.Entry::getValue;
    private final ActionCounter actionCounter = new ActionCounter();
    private boolean active1 = true;

    protected SessionMemory(KnowledgeImpl parent) {
        super(parent);
        this.ruleStorage = new RuntimeRules(this);
        this.typedMemories = new LinearHashMap(this.getTypeResolver().getKnownTypes().size());
        for (RuleDescriptor descriptor : this.getRuleDescriptors()) {
            this.deployRule(descriptor, false);
        }
    }

    protected void invalidateSession() {
        this.active1 = false;
    }

    protected void _assertActive() {
        if (!this.active1) {
            throw new IllegalStateException("Session has been closed");
        }
    }

    @Override
    public Iterator<TypeMemory> iterator() {
        return this.typedMemories.iterator(TYPE_MEMORY_MAPPING);
    }

    public ReIterator<TypeMemory> typeMemories() {
        return this.typedMemories.valueIterator();
    }

    public void reSortRules() {
        this.ruleStorage.sort(this.getRuleComparator());
    }

    @Override
    public void setRuleComparator(Comparator<Rule> ruleComparator) {
        super.setRuleComparator(ruleComparator);
        this.reSortRules();
    }

    public RuntimeRules getRuleStorage() {
        return this.ruleStorage;
    }

    @Override
    protected TypeResolver newTypeResolver() {
        return (TypeResolver)((AbstractRuntime)this.getParentContext()).getTypeResolver().copyOf();
    }

    @Override
    public final RuntimeContext.Kind getKind() {
        return RuntimeContext.Kind.SESSION;
    }

    @Override
    public RuntimeRule deployRule(RuleDescriptor descriptor) {
        return this.deployRule(descriptor, true);
    }

    private synchronized RuntimeRuleImpl deployRule(RuleDescriptor descriptor, boolean hotDeployment) {
        for (FactType factType : descriptor.getLhs().getAllFactTypes()) {
            this.touchMemory(factType.getFields(), factType.getAlphaMask());
        }
        RuntimeRuleImpl rule = this.ruleStorage.addRule(descriptor);
        if (hotDeployment) {
            this.getExecutor().invoke(new RuleHotDeploymentTask(rule));
        }
        this.reSortRules();
        return rule;
    }

    private void touchMemory(FieldsKey key, AlphaBucketMeta alphaMeta) {
        Type<?> t = key.getType();
        this.typedMemories.computeIfAbsent(t, k -> new TypeMemory(this, t)).touchMemory(key, alphaMeta);
    }

    @Override
    public void clear() {
        this.typedMemories.forEachValue(TypeMemory::clear);
        for (RuntimeRuleImpl rule : this.ruleStorage) {
            rule.clear();
        }
    }

    @Override
    public void insert(Object fact) {
        this.memoryAction(Action.INSERT, fact);
    }

    @Override
    public void insert(String factType, Object fact) {
        this.memoryAction(Action.INSERT, this.getTypeResolver().getType(factType), fact);
    }

    protected List<RuntimeRule> propagateInsertChanges() {
        for (TypeMemory tm : this) {
            tm.propagateBetaDeltas();
        }
        LinkedList<RuntimeRule> affectedRules = new LinkedList<RuntimeRule>();
        HashSet<BetaEndNode> affectedEndNodes = new HashSet<BetaEndNode>();
        for (RuntimeRuleImpl rule : this.ruleStorage) {
            rule.mergeNodeDeltas();
            boolean ruleAdded = false;
            for (TypeMemory tm : this) {
                Type t = tm.getType();
                if (!ruleAdded && rule.dependsOn(t)) {
                    affectedRules.add(rule);
                    ruleAdded = true;
                }
                for (BetaEndNode endNode : rule.getLhs().getAllBetaEndNodes()) {
                    if (!endNode.dependsOn(t)) continue;
                    affectedEndNodes.add(endNode);
                }
            }
        }
        LinkedList<RuleMemoryInsertTask> tasks = new LinkedList<RuleMemoryInsertTask>();
        if (!affectedEndNodes.isEmpty()) {
            tasks.add(new RuleMemoryInsertTask(affectedEndNodes, true));
        }
        if (tasks.size() > 0) {
            ForkJoinExecutor executor = this.getExecutor();
            for (Completer completer : tasks) {
                executor.invoke(completer);
            }
        }
        this.actionCounter.reset(Action.INSERT);
        return affectedRules;
    }

    protected void doDeletions() {
        for (TypeMemory tm : this) {
            tm.performDelete();
        }
        this.actionCounter.reset(Action.RETRACT);
    }

    @Override
    protected synchronized void onNewActiveField(ActiveField newField) {
        Type<?> t = newField.getDeclaringType();
        TypeMemory tm = (TypeMemory)this.typedMemories.get(t);
        if (tm == null) {
            tm = new TypeMemory(this, t);
            this.typedMemories.put(t, tm);
        } else {
            tm.onNewActiveField(newField);
        }
    }

    @Override
    protected void onNewAlphaBucket(AlphaDelta delta) {
        Type<?> t = delta.getKey().getType();
        TypeMemory tm = (TypeMemory)this.typedMemories.get(t);
        if (tm == null) {
            tm = new TypeMemory(this, t);
            this.typedMemories.put(t, tm);
        } else {
            tm.onNewAlphaBucket(delta);
        }
    }

    protected boolean hasActions(Action ... actions) {
        return this.actionCounter.hasActions(actions);
    }

    public SharedBetaFactStorage getBetaFactStorage(FactType factType) {
        Type<?> t = factType.getType();
        FieldsKey fields = factType.getFields();
        AlphaBucketMeta mask = factType.getAlphaMask();
        return this.get(t).get(fields).get(mask);
    }

    protected void destroy() {
        this.typedMemories.clear();
    }

    private void memoryAction(Action action, Object o) {
        this.memoryAction(action, this.getTypeResolver().resolve(o), o);
    }

    private void memoryAction(Action action, Type<?> t, Object o) {
        this._assertActive();
        if (t == null) {
            LOGGER.warning("Unknown object type of " + o + ", action " + (Object)((Object)action) + "  skipped");
        } else {
            this.memoryAction(action, this.get(t), o);
        }
    }

    private RuntimeFact memoryAction(Action action, TypeMemory tm, Object o) {
        RuntimeFact fact;
        switch (action) {
            case INSERT: {
                fact = tm.doInsert(o);
                break;
            }
            case RETRACT: {
                fact = tm.doDelete(o);
                break;
            }
            case UPDATE: {
                RuntimeFact deleted = this.memoryAction(Action.RETRACT, tm, o);
                if (deleted == null) {
                    LOGGER.warning("Unknown object: " + o + ", update skipped....");
                    fact = null;
                    break;
                }
                fact = this.memoryAction(Action.INSERT, tm, o);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (fact != null) {
            this.actionCounter.increment(action);
        }
        return fact;
    }

    @Override
    public <T> void forEachMemoryObject(String type, Consumer<T> consumer) {
        Type t = this.getTypeResolver().getType(type);
        if (t != null) {
            TypeMemory tm = (TypeMemory)this.typedMemories.get(t);
            tm.forEachMemoryObject(consumer);
        }
    }

    @Override
    public void forEachMemoryObject(Consumer<Object> consumer) {
        this.typedMemories.forEachValue(tm -> tm.forEachObjectUnchecked(consumer));
    }

    public List<RuntimeRule> getRules() {
        return this.ruleStorage.asList();
    }

    public TypeMemory get(Type<?> t) {
        TypeMemory m = (TypeMemory)this.typedMemories.get(t);
        if (m == null) {
            throw new IllegalArgumentException("No type memory created for " + t);
        }
        return m;
    }

    public void appendToBuffer(ActionQueue<Object> actions) {
        for (Action action : Action.values()) {
            ReIterator<Object> it = actions.get(action);
            while (it.hasNext()) {
                this.memoryAction(action, it.next());
            }
        }
    }

    @Override
    public void update(Object fact) {
        this.memoryAction(Action.UPDATE, fact);
    }

    @Override
    public void delete(Object fact) {
        this.memoryAction(Action.RETRACT, fact);
    }
}

