/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import org.evrete.api.ReIterable;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.SharedPlainFactStorage;
import org.evrete.runtime.PlainMemory;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.memory.SessionMemory;

class TypeMemoryBucket
implements PlainMemory {
    private final SharedPlainFactStorage data;
    private final SharedPlainFactStorage delta;
    private final AlphaBucketMeta alphaMask;

    TypeMemoryBucket(SessionMemory runtime, AlphaBucketMeta alphaMask) {
        this.data = runtime.newSharedPlainStorage();
        this.delta = runtime.newSharedPlainStorage();
        this.alphaMask = alphaMask;
    }

    void clear() {
        this.data.clear();
        this.delta.clear();
    }

    <T extends RuntimeFact> void fillMainStorage(ReIterator<T> iterator) {
        if (iterator.reset() > 0L) {
            while (iterator.hasNext()) {
                RuntimeFact rto = (RuntimeFact)iterator.next();
                if (!this.alphaMask.test(rto)) continue;
                this.data.insert(rto);
            }
        }
    }

    public SharedPlainFactStorage getData() {
        return this.data;
    }

    public SharedPlainFactStorage getDelta() {
        return this.delta;
    }

    @Override
    public boolean hasChanges() {
        return this.delta.size() > 0;
    }

    @Override
    public ReIterator<RuntimeFact> mainIterator() {
        return this.data.iterator();
    }

    @Override
    public ReIterator<RuntimeFact> deltaIterator() {
        return this.delta.iterator();
    }

    @Override
    public void commitChanges() {
        if (this.delta.size() > 0) {
            this.data.insert(this.delta);
            this.delta.clear();
        }
    }

    void insert(ReIterable<? extends RuntimeFact> facts) {
        ReIterator<? extends RuntimeFact> it = facts.iterator();
        this.delta.ensureExtraCapacity((int)it.reset());
        while (it.hasNext()) {
            this.insert((RuntimeFact)it.next());
        }
    }

    void insert(RuntimeFact fact) {
        if (this.alphaMask.test(fact)) {
            this.delta.insert(fact);
        }
    }

    void retract(ReIterable<? extends RuntimeFact> facts) {
        ReIterator<? extends RuntimeFact> it = facts.iterator();
        while (it.hasNext()) {
            RuntimeFact fact = (RuntimeFact)it.next();
            assert (fact.isDeleted());
        }
    }

    public String toString() {
        return "{data=" + this.data + ", delta=" + this.delta + ", alphaMask=" + this.alphaMask + '}';
    }
}

