/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.evrete.api.IntToValueRow;
import org.evrete.api.KeysStore;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueRow;
import org.evrete.collections.AbstractLinearHash;
import org.evrete.spi.minimal.KeysStoreEntry;
import org.evrete.spi.minimal.MiscUtils;

abstract class AbstractKeysStore<E extends KeysStoreEntry>
extends AbstractLinearHash<E>
implements KeysStore {
    static final BiPredicate<Object, Object> EQ_PREDICATE = (o1, o2) -> {
        KeysStoreEntry e1 = (KeysStoreEntry)o1;
        KeysStoreEntry e2 = (KeysStoreEntry)o2;
        return e1.eq(e2);
    };
    static final ToIntFunction<Object> HASH_FUNCTION = value -> ((KeysStoreEntry)value).hash;
    static final BiPredicate<KeysStoreEntry, ValueRow[]> EQ_FUNCTION = (entry, rows) -> MiscUtils.sameData(entry.key, rows);
    private static final BiPredicate<KeysStoreEntry, IntToValueRow> EQ_FUNCTION1 = (entry, intToValueRow) -> MiscUtils.eqEquals(intToValueRow, entry.key);
    private static final Function<KeysStoreEntry, KeysStore.Entry> KEY_MAPPER = entry -> entry;
    final int arrSize;
    final int level;

    public AbstractKeysStore(int level, int arrSize) {
        this.level = level;
        this.arrSize = arrSize;
    }

    @Override
    protected final ToIntFunction<Object> getHashFunction() {
        return HASH_FUNCTION;
    }

    @Override
    public final KeysStore.Entry get(IntToValueRow key) {
        int hash = MiscUtils.hash(key, this.arrSize);
        return (KeysStore.Entry)this.get(this.findBinIndex(key, hash, EQ_FUNCTION1));
    }

    @Override
    public final ReIterator<KeysStore.Entry> entries() {
        return this.iterator(KEY_MAPPER);
    }

    @Override
    protected final BiPredicate<Object, Object> getEqualsPredicate() {
        return EQ_PREDICATE;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }
}

