/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.ValueRow;
import org.evrete.collections.AbstractLinearHash;
import org.evrete.spi.minimal.ValueRowImpl;

class FieldsFactMap
extends AbstractLinearHash<ValueRowImpl> {
    private static final ToIntFunction<Object> HASH_FUNCTION = Object::hashCode;
    private static final BiPredicate<ValueRowImpl, ValueRowImpl> EQ_FUNCTION_TYPED = ValueRowImpl::equals;
    private static final Function<ValueRowImpl, ValueRow> IMPL_MAPPING = v -> v;

    FieldsFactMap() {
    }

    ReIterator<ValueRow> keyIterator() {
        return this.iterator(IMPL_MAPPING);
    }

    @Override
    protected ToIntFunction<Object> getHashFunction() {
        return HASH_FUNCTION;
    }

    public void addAll(FieldsFactMap other) {
        this.resize(this.size() + other.size() + 1);
        other.forEachDataEntry(this::insertOtherNoResize);
    }

    @Override
    protected BiPredicate<Object, Object> getEqualsPredicate() {
        return IDENTITY_EQUALS;
    }

    private void insertOtherNoResize(ValueRowImpl other) {
        int hash = other.hashCode();
        int addr = this.findBinIndex(other, hash, EQ_FUNCTION_TYPED);
        ValueRowImpl found = (ValueRowImpl)this.get(addr);
        if (found == null) {
            this.saveDirect(other, addr);
        } else {
            found.mergeDataFrom(other);
        }
    }

    void remove(RuntimeFact fact, int addr) {
        ValueRowImpl entry = (ValueRowImpl)this.get(addr);
        if (entry != null && entry.removeFact(fact) == 0L) {
            this.markDeleted(addr);
            entry.setDeleted(true);
        }
    }
}

