/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.evrete.spi.minimal.JcClassLoader;
import org.evrete.spi.minimal.JcCompilationException;
import org.evrete.spi.minimal.JcFileManager;
import org.evrete.spi.minimal.JcJavaSource;

class JcCompiler {
    private static final Logger LOGGER = Logger.getLogger(JcCompiler.class.getName());
    private final JcClassLoader classLoader;
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

    public JcCompiler(ClassLoader classLoader) {
        this.classLoader = new JcClassLoader(classLoader);
    }

    public Class<?> compile(String className, String source) {
        long t0 = Calendar.getInstance().getTimeInMillis();
        try {
            byte[] bytes = this.compileSourceToClassBytes(className, source);
            Class<?> clazz = this.classLoader.buildClass(className, bytes);
            return clazz;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to compile source:\n" + source, e);
            throw new JcCompilationException(e);
        }
        finally {
            long t1 = Calendar.getInstance().getTimeInMillis();
            LOGGER.fine("Compile time: " + (t1 - t0) + "ms, source: " + source);
        }
    }

    private byte[] compileSourceToClassBytes(String className, String source) {
        boolean success;
        JcFileManager<?> fileManager = JcFileManager.instance(this.compiler, this.classLoader.getParent());
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        try {
            success = this.compiler.getTask(null, fileManager, diagnostics, null, null, JcJavaSource.task(className, source)).call();
        }
        catch (Throwable t) {
            throw new JcCompilationException(t.getCause());
        }
        if (success) {
            return fileManager.getBytes();
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
            errors.add(diagnostic.toString());
        }
        throw new JcCompilationException("Unknown compilation error: " + errors);
    }
}

