/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Arrays;
import java.util.StringJoiner;
import java.util.function.IntFunction;
import org.evrete.api.IntToValueRow;
import org.evrete.api.KeysStore;
import org.evrete.api.ValueRow;
import org.evrete.spi.minimal.AbstractKeysStore;
import org.evrete.spi.minimal.KeysStoreEntry;
import org.evrete.spi.minimal.MiscUtils;

class KeysStorePlain
extends AbstractKeysStore<MapEntry> {
    KeysStorePlain(int level, int arrSize) {
        super(level, arrSize);
    }

    @Override
    public void save(IntFunction<IntToValueRow> values) {
        this.resize();
        ValueRow[] key = MiscUtils.toArray(values.apply(this.level), this.arrSize);
        int hash = MiscUtils.hash(key);
        int addr = this.findBinIndex(key, hash, EQ_FUNCTION);
        MapEntry found = (MapEntry)this.get(addr);
        if (found == null) {
            found = new MapEntry(key, hash);
            this.saveDirect(found, addr);
        }
    }

    @Override
    public final void append(KeysStore store) {
        KeysStorePlain other = (KeysStorePlain)store;
        super.bulkAdd(other);
    }

    @Override
    public final String toString() {
        StringJoiner j = new StringJoiner(", ");
        this.forEachDataEntry(arr -> j.add(Arrays.toString(arr.key)));
        return j.toString();
    }

    static final class MapEntry
    extends KeysStoreEntry {
        MapEntry(ValueRow[] key, int hash) {
            super(key, hash);
        }

        @Override
        public final KeysStore getNext() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return Arrays.toString(this.key);
        }
    }
}

