/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Arrays;
import org.evrete.api.IntToValueRow;
import org.evrete.api.ValueRow;

final class MiscUtils {
    MiscUtils() {
    }

    public static Class<?> classForName(String className) {
        switch (className) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        String fqn = className.contains(".") ? className : "java.lang.".concat(className);
        try {
            return Class.forName(fqn);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Class not found: " + fqn);
        }
    }

    static int hash(ValueRow[] v) {
        int h = 0;
        for (int i = 0; i < v.length; ++i) {
            h ^= v[i].hashCode();
        }
        return h;
    }

    static ValueRow[] toArray(IntToValueRow v, int size) {
        ValueRow[] arr = new ValueRow[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = v.apply(i);
        }
        return arr;
    }

    static int hash(IntToValueRow v, int size) {
        int h = 0;
        for (int i = 0; i < size; ++i) {
            h ^= v.apply(i).hashCode();
        }
        return h;
    }

    static boolean eqEquals(IntToValueRow v, ValueRow[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (v.apply(i).equals(arr[i])) continue;
            return false;
        }
        return true;
    }

    static boolean sameData(Object[] arr1, Object[] arr2) {
        return Arrays.equals(arr1, arr2);
    }
}

