/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Objects;
import java.util.function.Function;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.spi.minimal.TypeImpl;

class TypeFieldImpl
implements TypeField {
    private final String name;
    private final Function<Object, ?> function;
    private final Class<?> valueType;
    private final TypeImpl<?> declaringType;

    TypeFieldImpl(TypeImpl<?> declaringType, String name, Class<?> valueType, Function<Object, ?> function) {
        this.name = name;
        this.valueType = valueType;
        this.function = function;
        this.declaringType = declaringType;
    }

    @Override
    public Type<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public Class<?> getValueType() {
        return this.valueType;
    }

    @Override
    public Object readValue(Object subject) {
        return this.function.apply(subject);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "{name='" + this.name + '\'' + ", type='" + this.valueType + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeFieldImpl typeField = (TypeFieldImpl)o;
        return this.name.equals(typeField.name) && this.declaringType.equals(typeField.declaringType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.declaringType);
    }
}

