/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.TypeResolver;
import org.evrete.api.TypeWrapper;
import org.evrete.collections.ArrayOf;
import org.evrete.spi.minimal.JcCompiler;
import org.evrete.spi.minimal.TypeImpl;

class TypeResolverImpl
implements TypeResolver {
    private static final Logger LOGGER = Logger.getLogger(TypeResolverImpl.class.getName());
    private static final List<Class<?>> EMPTY_CLASS_LIST = new ArrayList();
    private final Map<String, Type<?>> typeDeclarationMap = new HashMap();
    private final Map<String, ArrayOf<Type<?>>> typesByJavaType = new HashMap();
    private final Map<String, TypeCacheEntry> typeInheritanceCache = new HashMap<String, TypeCacheEntry>();
    private final JcCompiler compiler;
    private final ClassLoader classLoader;
    private int typeCounter = 0;
    private int fieldSetsCounter = 0;

    public TypeResolverImpl(RuntimeContext<?> requester) {
        this.classLoader = requester.getClassLoader();
        this.compiler = new JcCompiler(this.classLoader);
    }

    private TypeResolverImpl(TypeResolverImpl other) {
        this.compiler = other.compiler;
        this.classLoader = other.classLoader;
        this.typeCounter = other.typeCounter;
        this.fieldSetsCounter = other.fieldSetsCounter;
        for (Map.Entry<String, Type<?>> entry : other.typeDeclarationMap.entrySet()) {
            this.typeDeclarationMap.put(entry.getKey(), (Type)entry.getValue().copyOf());
        }
        for (Map.Entry<String, Object> entry : other.typesByJavaType.entrySet()) {
            this.typesByJavaType.put(entry.getKey(), new ArrayOf((ArrayOf)entry.getValue()));
        }
    }

    @Override
    public synchronized void wrapType(TypeWrapper<?> typeWrapper) {
        Type<?> delegate = typeWrapper.getDelegate();
        String typeName = typeWrapper.getName();
        Type prev = this.typeDeclarationMap.put(typeName, typeWrapper);
        if (prev != delegate) {
            throw new IllegalStateException(typeWrapper + " wraps an unknown type");
        }
        ArrayOf<Type<?>> byJavaTypes = this.typesByJavaType.get(typeWrapper.getJavaType().getName());
        if (byJavaTypes == null) {
            throw new IllegalStateException();
        }
        boolean changed = false;
        for (int i = 0; i < ((Type[])byJavaTypes.data).length; ++i) {
            if (((Type[])byJavaTypes.data)[i] != delegate) continue;
            ((Type[])byJavaTypes.data)[i] = typeWrapper;
            changed = true;
            break;
        }
        if (!changed) {
            throw new IllegalStateException();
        }
    }

    private static List<Class<?>> superClasses(Class<?> subject) {
        if (subject.isArray() || subject.isPrimitive() || subject.equals(Object.class)) {
            return EMPTY_CLASS_LIST;
        }
        ArrayList l = new ArrayList();
        Class<?> current = subject.getSuperclass();
        while (!current.equals(Object.class)) {
            l.add(current);
            current = current.getSuperclass();
        }
        return l;
    }

    private <T> Class<T> classForName(String javaType) {
        try {
            return Class.forName(javaType, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public synchronized <T> Type<T> declare(String typeName, String javaType) {
        Type<T> type = this.getType(typeName);
        if (type != null) {
            throw new IllegalStateException("Type name '" + typeName + "' has been already defined: " + type);
        }
        Class<T> resolvedJavaType = this.classForName(javaType);
        if (resolvedJavaType == null) {
            throw new IllegalStateException("Unable to resolve Java class name '" + javaType + "'");
        }
        return this.saveNewType(typeName, new TypeImpl<T>(typeName, resolvedJavaType));
    }

    @Override
    public synchronized <T> Type<T> declare(String typeName, Class<T> javaType) {
        Type<T> type = this.getType(typeName);
        if (type != null) {
            throw new IllegalStateException("Type name '" + typeName + "' has been already defined: " + type);
        }
        return this.saveNewType(typeName, new TypeImpl<T>(typeName, javaType));
    }

    private <T> Type<T> saveNewType(String typeName, Type<T> type) {
        this.typeDeclarationMap.put(typeName, type);
        this.typesByJavaType.computeIfAbsent(type.getJavaType().getName(), k -> new ArrayOf<Type>(new Type[0])).append(type);
        this.typeInheritanceCache.clear();
        return type;
    }

    @Override
    public Collection<Type<?>> getKnownTypes() {
        return Collections.unmodifiableCollection(this.typeDeclarationMap.values());
    }

    @Override
    public <T> Type<T> getType(String name) {
        return this.typeDeclarationMap.get(name);
    }

    private Type<?> findInSuperClasses(Class<?> type) {
        LinkedList<Type> matching = new LinkedList<Type>();
        List<Class<?>> superClasses = TypeResolverImpl.superClasses(type);
        for (Class<?> sup : superClasses) {
            String supName = sup.getName();
            ArrayOf<Type<?>> match = this.typesByJavaType.get(supName);
            if (match == null || ((Type[])match.data).length != 1) continue;
            matching.add(((Type[])match.data)[0]);
        }
        switch (matching.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Type)matching.iterator().next();
            }
        }
        LOGGER.warning("Unable to resolve type '" + type + "' due to ambiguity.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Type<T> resolve(Object o) {
        Objects.requireNonNull(o);
        Class<?> javaType = o.getClass();
        String name = javaType.getName();
        ArrayOf<Type<?>> associatedTypes = this.typesByJavaType.get(name);
        if (associatedTypes != null) {
            if (((Type[])associatedTypes.data).length > 1) {
                LOGGER.warning("Ambiguous type declaration found, there are " + ((Type[])associatedTypes.data).length + " types associated with '" + name + "' Java type, returning <null>.");
                return null;
            }
            return ((Type[])associatedTypes.data)[0];
        }
        TypeCacheEntry cacheEntry = this.typeInheritanceCache.get(name);
        if (cacheEntry == null) {
            TypeResolverImpl typeResolverImpl = this;
            synchronized (typeResolverImpl) {
                cacheEntry = this.typeInheritanceCache.get(name);
                if (cacheEntry == null) {
                    cacheEntry = new TypeCacheEntry(this.findInSuperClasses(javaType));
                    this.typeInheritanceCache.put(name, cacheEntry);
                }
            }
        }
        return (TypeImpl)cacheEntry.type;
    }

    @Override
    public TypeResolverImpl copyOf() {
        return new TypeResolverImpl(this);
    }

    private static class TypeCacheEntry {
        private final Type<?> type;

        TypeCacheEntry(Type<?> resolved) {
            this.type = resolved;
        }
    }
}

