package org.evrete.api;

import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;

//TODO javadoc
public interface StatefulSession extends WorkingMemory, RuntimeContext<StatefulSession> {

    StatefulSession setFireCriteria(BooleanSupplier fireCriteria);

    void fire();

    void close();

    ActivationManager getActivationManager();

    StatefulSession setActivationManager(ActivationManager activationManager);

    @Override
    StatefulSession addImport(String imp);

    @Override
    StatefulSession addImport(Class<?> type);

    RuntimeRule getRule(String name);

    List<RuntimeRule> getRules();

    default RuntimeRule getRule(Named named) {
        return getRule(named.getName());
    }

    default void insertAndFire(Collection<?> objects) {
        insert(objects);
        fire();
    }

    default void insertAndFire(Object... objects) {
        insert(objects);
        fire();
    }

    default void deleteAndFire(Object... objects) {
        delete(objects);
        fire();
    }

    default void deleteAndFire(Collection<?> objects) {
        delete(objects);
        fire();
    }

    default void updateAndFire(Object... objects) {
        update(objects);
        fire();
    }

    default void updateAndFire(Collection<?> objects) {
        update(objects);
        fire();
    }

}
