/*
 * Decompiled with CFR 0.152.
 */
package org.evrete;

import java.util.Properties;
import java.util.logging.Logger;
import org.evrete.api.Copyable;

public class Configuration
extends Properties
implements Copyable<Configuration> {
    public static final String OBJECT_COMPARE_METHOD = "evrete.core.fact-identity-strategy";
    public static final String INSERT_BUFFER_SIZE = "evrete.core.insert-buffer-size";
    public static final String WARN_UNKNOWN_TYPES = "evrete.core.warn-unknown-types";
    public static final int INSERT_BUFFER_SIZE_DEFAULT = 4096;
    static final String PARALLELISM = "evrete.core.parallelism";
    private static final Logger LOGGER = Logger.getLogger(Configuration.class.getName());
    public static final String IDENTITY_METHOD_EQUALS = "equals";
    public static final String IDENTITY_METHOD_IDENTITY = "identity";
    private static final long serialVersionUID = -9015471049604658637L;

    public Configuration(Properties defaults) {
        this();
        for (String key : defaults.stringPropertyNames()) {
            this.setProperty(key, defaults.getProperty(key));
        }
    }

    public Configuration() {
        this.setProperty(WARN_UNKNOWN_TYPES, Boolean.TRUE.toString());
        this.setProperty(OBJECT_COMPARE_METHOD, IDENTITY_METHOD_IDENTITY);
        this.setProperty(INSERT_BUFFER_SIZE, String.valueOf(4096));
    }

    public boolean getAsBoolean(String property) {
        return Boolean.parseBoolean(this.getProperty(property));
    }

    public int getAsInteger(String property, int defaultValue) {
        String val = this.getProperty(property);
        if (val == null || val.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception e) {
            LOGGER.warning("Property '" + property + "' is not an integer, returning default value of " + defaultValue);
            return defaultValue;
        }
    }

    @Override
    public Configuration copyOf() {
        return new Configuration(this);
    }
}

