/*
 * Decompiled with CFR 0.152.
 */
package org.evrete;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.evrete.Configuration;
import org.evrete.SourceSecurity;
import org.evrete.api.Knowledge;
import org.evrete.api.OrderedServiceProvider;
import org.evrete.api.StatefulSession;
import org.evrete.api.spi.ExpressionResolverProvider;
import org.evrete.api.spi.LiteralRhsCompiler;
import org.evrete.api.spi.MemoryFactoryProvider;
import org.evrete.api.spi.TypeResolverProvider;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.runtime.async.ForkJoinExecutor;

public class KnowledgeService {
    private final Configuration configuration;
    private final ForkJoinExecutor executor;
    private final MemoryFactoryProvider collectionsServiceProvider;
    private final ExpressionResolverProvider expressionResolverProvider;
    private final TypeResolverProvider typeResolverProvider;
    private final LiteralRhsCompiler literalRhsProvider;
    private ClassLoader classLoader;
    private final SourceSecurity security = new SourceSecurity();

    public KnowledgeService(Configuration conf) {
        this.configuration = conf;
        this.executor = new ForkJoinExecutor(conf.getAsInteger("evrete.core.parallelism", Runtime.getRuntime().availableProcessors()));
        this.collectionsServiceProvider = KnowledgeService.loadService(MemoryFactoryProvider.class);
        this.expressionResolverProvider = KnowledgeService.loadService(ExpressionResolverProvider.class);
        this.typeResolverProvider = KnowledgeService.loadService(TypeResolverProvider.class);
        this.literalRhsProvider = KnowledgeService.loadService(LiteralRhsCompiler.class);
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public KnowledgeService() {
        this(new Configuration());
    }

    private static <Z extends OrderedServiceProvider> Z loadService(Class<Z> clazz) {
        LinkedList providers = new LinkedList();
        Iterator<Z> sl = ServiceLoader.load(clazz).iterator();
        sl.forEachRemaining(providers::add);
        Collections.sort(providers);
        if (providers.isEmpty()) {
            throw new IllegalStateException("Implementation missing: " + clazz);
        }
        return (Z)((OrderedServiceProvider)providers.iterator().next());
    }

    public SourceSecurity getSecurity() {
        return this.security;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Knowledge newKnowledge() {
        return new KnowledgeRuntime(this);
    }

    public StatefulSession newSession() {
        return this.newKnowledge().createSession();
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public ForkJoinExecutor getExecutor() {
        return this.executor;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public MemoryFactoryProvider getMemoryFactoryProvider() {
        return this.collectionsServiceProvider;
    }

    public ExpressionResolverProvider getExpressionResolverProvider() {
        return this.expressionResolverProvider;
    }

    public LiteralRhsCompiler getLiteralRhsCompiler() {
        return this.literalRhsProvider;
    }

    public TypeResolverProvider getTypeResolverProvider() {
        return this.typeResolverProvider;
    }
}

