/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.MemoryKeyCollection;
import org.evrete.api.ReIterator;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.BetaConditionNode;
import org.evrete.runtime.BetaMemoryNode;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.RuntimeRuleImpl;

public abstract class AbstractBetaConditionNode
implements BetaMemoryNode {
    private final ConditionNodeDescriptor descriptor;
    private final BetaMemoryNode[] sources;
    private final BetaConditionNode[] conditionSources;
    private final RuntimeRuleImpl rule;
    private final MemoryKeyCollection[] stores = new MemoryKeyCollection[KeyMode.values().length];
    private boolean mergeToMain = true;

    AbstractBetaConditionNode(RuntimeRuleImpl rule, ConditionNodeDescriptor descriptor, BetaMemoryNode[] sources) {
        this.sources = sources;
        ArrayList<BetaConditionNode> conditionNodeList = new ArrayList<BetaConditionNode>(sources.length);
        for (BetaMemoryNode betaMemoryNode : sources) {
            if (!betaMemoryNode.getDescriptor().isConditionNode()) continue;
            conditionNodeList.add((BetaConditionNode)betaMemoryNode);
        }
        this.conditionSources = conditionNodeList.toArray(BetaConditionNode.EMPTY_ARRAY);
        this.rule = rule;
        this.descriptor = descriptor;
        for (KeyMode keyMode : KeyMode.values()) {
            this.stores[keyMode.ordinal()] = ((AbstractRuleSession)rule.getRuntime()).memory.memoryFactory.newMemoryKeyCollection(descriptor.getTypes());
        }
    }

    void commitDelta1() {
        MemoryKeyCollection delta1 = this.getStore(KeyMode.UNKNOWN_UNKNOWN);
        MemoryKeyCollection delta2 = this.getStore(KeyMode.KNOWN_UNKNOWN);
        if (this.mergeToMain) {
            MemoryKeyCollection main = this.getStore(KeyMode.MAIN);
            ReIterator it = delta1.iterator();
            while (it.hasNext()) {
                MemoryKey key = (MemoryKey)it.next();
                key.setMetaValue(KeyMode.MAIN.ordinal());
                main.add(key);
            }
        }
        delta1.clear();
        delta2.clear();
    }

    void setMergeToMain(boolean mergeToMain) {
        this.mergeToMain = mergeToMain;
    }

    MemoryKeyCollection getStore(KeyMode mode) {
        return this.stores[mode.ordinal()];
    }

    AbstractRuleSession<?> getRuntime() {
        return this.rule.getRuntime();
    }

    public BetaConditionNode[] getConditionSources() {
        return this.conditionSources;
    }

    BetaMemoryNode[] getSources() {
        return this.sources;
    }

    @Override
    public ConditionNodeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public ReIterator<MemoryKey> iterator(KeyMode mode) {
        return this.getStore(mode).iterator();
    }

    @Override
    public void clear() {
        for (MemoryKeyCollection s : this.stores) {
            s.clear();
        }
        for (BetaMemoryNode source : this.getSources()) {
            source.clear();
        }
    }
}

