/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.evrete.api.ActivationManager;
import org.evrete.api.EvaluationListener;
import org.evrete.api.Rule;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuleSession;
import org.evrete.api.RuntimeRule;
import org.evrete.api.Type;
import org.evrete.runtime.AbstractWorkingMemory;
import org.evrete.runtime.ActivationContext;
import org.evrete.runtime.AtomicMemoryAction;
import org.evrete.runtime.BetaEndNode;
import org.evrete.runtime.FactType;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.RuntimeRules;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.async.Completer;
import org.evrete.runtime.async.ForkJoinExecutor;
import org.evrete.runtime.async.RuleHotDeploymentTask;
import org.evrete.runtime.async.RuleMemoryInsertTask;

abstract class AbstractRuleSession<S extends RuleSession<S>>
extends AbstractWorkingMemory<S> {
    private final RuntimeRules ruleStorage;
    private ActivationManager activationManager;
    private BooleanSupplier fireCriteria = () -> true;

    AbstractRuleSession(KnowledgeRuntime knowledge) {
        super(knowledge);
        this.activationManager = this.newActivationManager();
        this.ruleStorage = new RuntimeRules();
        for (RuleDescriptor descriptor : knowledge.getRules()) {
            this.deployRule(descriptor, false);
        }
    }

    private void reSortRules() {
        this.ruleStorage.sort(this.getRuleComparator());
    }

    private List<RuntimeRule> buildMemoryDeltas() {
        return this.buildMemoryDeltasInsecure();
    }

    @Override
    public RuntimeRule compileRule(RuleBuilder<?> builder) {
        RuleDescriptor rd = this.compileRuleBuilder(builder);
        return this.deployRule(rd, true);
    }

    @Override
    public List<RuntimeRule> getRules() {
        return this.ruleStorage.asList();
    }

    private List<RuntimeRule> buildMemoryDeltasInsecure() {
        LinkedList<RuntimeRule> affectedRules = new LinkedList<RuntimeRule>();
        HashSet<BetaEndNode> affectedEndNodes = new HashSet<BetaEndNode>();
        for (RuntimeRuleImpl rule : this.ruleStorage) {
            rule.mergeNodeDeltas();
            boolean ruleAdded = false;
            for (TypeMemory tm : this.memory) {
                Type<?> t = tm.getType();
                if (!ruleAdded && rule.dependsOn(t)) {
                    affectedRules.add(rule);
                    ruleAdded = true;
                }
                for (BetaEndNode endNode : rule.getLhs().getEndNodes()) {
                    if (!endNode.dependsOn(t)) continue;
                    affectedEndNodes.add(endNode);
                }
            }
        }
        LinkedList<RuleMemoryInsertTask> tasks = new LinkedList<RuleMemoryInsertTask>();
        if (!affectedEndNodes.isEmpty()) {
            tasks.add(new RuleMemoryInsertTask(affectedEndNodes, true));
        }
        if (tasks.size() > 0) {
            ForkJoinExecutor executor = this.getExecutor();
            for (Completer completer : tasks) {
                executor.invoke(completer);
            }
        }
        return affectedRules;
    }

    @Override
    public void setRuleComparator(Comparator<Rule> ruleComparator) {
        super.setRuleComparator(ruleComparator);
        this.reSortRules();
    }

    private synchronized RuntimeRule deployRule(RuleDescriptor descriptor, boolean hotDeployment) {
        for (FactType factType : descriptor.getLhs().getFactTypes()) {
            this.memory.touchMemory(factType.getFields(), factType.getAlphaMask());
        }
        RuntimeRuleImpl rule = this.ruleStorage.addRule(descriptor, this);
        if (hotDeployment) {
            this.getExecutor().invoke(new RuleHotDeploymentTask(rule));
        }
        this.reSortRules();
        return rule;
    }

    @Override
    public void clear() {
        super.clear();
        for (RuntimeRuleImpl rule : this.ruleStorage) {
            rule.clear();
        }
    }

    @Override
    public void addListener(EvaluationListener listener) {
        this.forEachAlphaCondition(a -> a.addListener(listener));
        this.ruleStorage.addListener(listener);
    }

    @Override
    public void removeListener(EvaluationListener listener) {
        this.forEachAlphaCondition(a -> a.removeListener(listener));
        this.ruleStorage.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AbstractRuleSession abstractRuleSession = this;
        synchronized (abstractRuleSession) {
            this.invalidateSession();
            this.knowledge.close(this);
        }
    }

    @Override
    public ActivationManager getActivationManager() {
        return this.activationManager;
    }

    void applyActivationManager(ActivationManager activationManager) {
        this.activationManager = activationManager;
    }

    @Override
    public <A extends ActivationManager> void setActivationManagerFactory(Class<A> managerClass) {
        super.setActivationManagerFactory(managerClass);
        this.activationManager = this.newActivationManager();
    }

    void applyFireCriteria(BooleanSupplier fireCriteria) {
        this.fireCriteria = fireCriteria;
    }

    @Override
    public void fire() {
        switch (this.getAgendaMode()) {
            case DEFAULT: {
                this.fireDefault(new ActivationContext());
                break;
            }
            case CONTINUOUS: {
                this.fireContinuous(new ActivationContext());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode " + (Object)((Object)this.getAgendaMode()));
            }
        }
    }

    private void fireContinuous(ActivationContext ctx) {
        while (this.fireCriteria.getAsBoolean() && this.buffer.hasData()) {
            this.processBuffer();
            List<RuntimeRule> agenda = this.buildMemoryDeltas();
            if (agenda.isEmpty()) continue;
            this.activationManager.onAgenda(ctx.incrementFireCount(), agenda);
            for (RuntimeRule candidate : agenda) {
                RuntimeRuleImpl rule = (RuntimeRuleImpl)candidate;
                if (!this.activationManager.test(candidate)) continue;
                this.activationManager.onActivation(rule, rule.executeRhs());
            }
            this.commitInserts();
        }
    }

    private void fireDefault(ActivationContext ctx) {
        while (this.fireCriteria.getAsBoolean() && this.buffer.hasData()) {
            this.processBuffer();
            List<RuntimeRule> agenda = this.buildMemoryDeltas();
            if (agenda.isEmpty()) continue;
            this.activationManager.onAgenda(ctx.incrementFireCount(), agenda);
            for (RuntimeRule candidate : agenda) {
                RuntimeRuleImpl rule = (RuntimeRuleImpl)candidate;
                if (!this.activationManager.test(candidate)) continue;
                this.activationManager.onActivation(rule, rule.executeRhs());
                int deltaOperations = this.buffer.deltaOperations();
                if (deltaOperations > 0) break;
                this.processBuffer();
            }
            this.commitInserts();
        }
    }

    private void processBuffer() {
        Iterator<AtomicMemoryAction> it = this.buffer.actions();
        while (it.hasNext()) {
            AtomicMemoryAction a = it.next();
            int typeId = a.handle.getTypeId();
            TypeMemory tm = this.getMemory().get(typeId);
            tm.processMemoryChange(a.action, a.handle, a.factRecord);
        }
        this.buffer.clear();
    }

    private void commitInserts() {
        this.memory.commitChanges();
    }
}

