/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import org.evrete.Configuration;
import org.evrete.KnowledgeService;
import org.evrete.api.ActivationManager;
import org.evrete.api.ActivationMode;
import org.evrete.api.Evaluator;
import org.evrete.api.ExpressionResolver;
import org.evrete.api.NamedType;
import org.evrete.api.RhsContext;
import org.evrete.api.Rule;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuleSet;
import org.evrete.api.RuntimeContext;
import org.evrete.api.TypeResolver;
import org.evrete.api.TypeResolverWrapper;
import org.evrete.api.spi.DSLKnowledgeProvider;
import org.evrete.runtime.FactType;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeMetaData;
import org.evrete.runtime.async.ForkJoinExecutor;
import org.evrete.runtime.builder.FactTypeBuilder;
import org.evrete.runtime.builder.RuleBuilderImpl;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.evaluation.EvaluatorWrapper;
import org.evrete.util.DefaultActivationManager;
import org.evrete.util.compiler.CompilationException;

public abstract class AbstractRuntime<R extends Rule, C extends RuntimeContext<C>>
extends RuntimeMetaData<C>
implements RuleSet<R> {
    private final List<RuleBuilder<C>> ruleBuilders = new ArrayList<RuleBuilder<C>>();
    private final KnowledgeService service;
    private ExpressionResolver expressionResolver;
    private TypeResolver typeResolver;
    private ClassLoader classLoader;
    private Comparator<Rule> ruleComparator = SALIENCE_COMPARATOR;
    private Class<? extends ActivationManager> activationManagerFactory;
    private ActivationMode agendaMode;
    private final Configuration configuration;

    AbstractRuntime(KnowledgeService service) {
        this.configuration = service.getConfiguration().copyOf();
        this.service = service;
        this.activationManagerFactory = DefaultActivationManager.class;
        this.classLoader = service.getClassLoader();
        this.agendaMode = ActivationMode.DEFAULT;
        this.typeResolver = service.getTypeResolverProvider().instance(this);
    }

    AbstractRuntime(AbstractRuntime<?, ?> parent) {
        super(parent);
        this.configuration = parent.configuration.copyOf();
        this.service = parent.service;
        this.ruleComparator = parent.ruleComparator;
        this.activationManagerFactory = parent.activationManagerFactory;
        this.classLoader = parent.classLoader;
        this.agendaMode = parent.agendaMode;
        this.typeResolver = (TypeResolver)parent.typeResolver.copyOf();
        this.expressionResolver = null;
    }

    ActivationMode getAgendaMode() {
        return this.agendaMode;
    }

    @Override
    public C setActivationMode(ActivationMode activationMode) {
        this.agendaMode = activationMode;
        return (C)this;
    }

    private static DSLKnowledgeProvider getDslProvider(String dsl) {
        Objects.requireNonNull(dsl);
        ServiceLoader<DSLKnowledgeProvider> loader = ServiceLoader.load(DSLKnowledgeProvider.class);
        LinkedList<DSLKnowledgeProvider> found = new LinkedList<DSLKnowledgeProvider>();
        StringJoiner knownProviders = new StringJoiner(",", "[", "]");
        for (DSLKnowledgeProvider provider : loader) {
            String name = provider.getName();
            if (dsl.equals(name)) {
                found.add(provider);
            }
            knownProviders.add("'" + name + "' = " + provider.getClass());
        }
        if (found.isEmpty()) {
            throw new IllegalStateException("DSL provider '" + dsl + "' is not found. Make sure the corresponding implementation is available on the classpath. Available providers: " + knownProviders);
        }
        if (found.size() > 1) {
            throw new IllegalStateException("Multiple DSL providers found implementing the '" + dsl + "' language. Known providers: " + knownProviders);
        }
        return (DSLKnowledgeProvider)found.iterator().next();
    }

    protected void append(String dsl, InputStream ... streams) throws IOException {
        AbstractRuntime.getDslProvider(dsl).apply(this, streams);
    }

    protected void append(String dsl, Reader ... readers) throws IOException {
        AbstractRuntime.getDslProvider(dsl).apply(this, readers);
    }

    protected void append(String dsl, URL ... resources) throws IOException {
        AbstractRuntime.getDslProvider(dsl).apply(this, resources);
    }

    private static URL classToURL(Class<?> cl) {
        String resource = cl.getName().replaceAll("\\.", "/") + ".class";
        return cl.getClassLoader().getResource(resource);
    }

    protected void append(String dsl, Class<?> ... classes) throws IOException {
        if (classes == null || classes.length == 0) {
            return;
        }
        URL[] urls = new URL[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            urls[i] = AbstractRuntime.classToURL(classes[i]);
        }
        AbstractRuntime.getDslProvider(dsl).apply(this, urls);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public KnowledgeService getService() {
        return this.service;
    }

    @Override
    public final void wrapTypeResolver(TypeResolverWrapper wrapper) {
        this.typeResolver = wrapper;
    }

    @Override
    public final TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public Class<? extends ActivationManager> getActivationManagerFactory() {
        return this.activationManagerFactory;
    }

    @Override
    public <A extends ActivationManager> void setActivationManagerFactory(Class<A> managerClass) {
        this.activationManagerFactory = managerClass;
    }

    @Override
    public final void setActivationManagerFactory(String managerClass) {
        try {
            Class<?> factory = Class.forName(managerClass, true, this.classLoader);
            this.setActivationManagerFactory(factory);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(managerClass);
        }
    }

    ActivationManager newActivationManager() {
        try {
            return this.activationManagerFactory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to create activation manager. Probably the provided factory class has no public and zero-argument constructor.", e);
        }
    }

    @Override
    public Comparator<Rule> getRuleComparator() {
        return this.ruleComparator;
    }

    @Override
    public void setRuleComparator(Comparator<Rule> ruleComparator) {
        this.ruleComparator = ruleComparator;
    }

    ForkJoinExecutor getExecutor() {
        return this.service.getExecutor();
    }

    public Evaluator compile(String expression, Function<String, NamedType> resolver, Set<String> imports) {
        try {
            return this.getExpressionResolver().buildExpression(expression, resolver, imports);
        }
        catch (CompilationException e) {
            Logger.getAnonymousLogger().warning("Failed code:\n" + e.getSource());
            throw new RuntimeException(e);
        }
    }

    FactType buildFactType(FactTypeBuilder builder, Set<EvaluatorWrapper> alphaEvaluators, int inRuleId) {
        FieldsKey fieldsKey = this.getCreateMemoryKey(builder);
        AlphaBucketMeta alphaMask = this.buildAlphaMask(fieldsKey, alphaEvaluators);
        return new FactType(builder.getVar(), alphaMask, fieldsKey, inRuleId);
    }

    @Override
    public RuleBuilder<C> newRule() {
        return this.newRule(null);
    }

    @Override
    public RuleBuilderImpl<C> newRule(String name) {
        RuleBuilderImpl rb = new RuleBuilderImpl(this, name);
        this.ruleBuilders.add(rb);
        return rb;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    synchronized RuleDescriptor compileRuleBuilder(RuleBuilder<?> ruleBuilder) {
        if (!this.ruleBuilders.remove(ruleBuilder)) {
            throw new IllegalArgumentException("No such rule builder");
        }
        int currentRuleCount = this.getRules().size();
        String ruleName = ruleBuilder.getName();
        int salience = ruleBuilder.getSalience();
        if (salience == RuleBuilderImpl.NULL_SALIENCE) {
            salience = -1 * (currentRuleCount + 1);
        }
        if (ruleName == null) {
            ruleName = "Rule#" + currentRuleCount;
        }
        if (this.ruleExists(ruleBuilder.getName())) {
            throw new IllegalArgumentException("Rule '" + ruleBuilder.getName() + "' already exists");
        }
        RuleBuilderImpl rb = (RuleBuilderImpl)ruleBuilder;
        return RuleDescriptor.factory(this, rb, ruleName, salience);
    }

    Consumer<RhsContext> compile(String literalRhs, FactType[] factTypes, Collection<String> imports) {
        try {
            return this.service.getLiteralRhsCompiler().compileRhs(this, literalRhs, Arrays.asList(factTypes), imports);
        }
        catch (CompilationException e) {
            Logger.getAnonymousLogger().warning("Failed source\n: " + e.getSource());
            throw new IllegalStateException(e);
        }
    }

    @Override
    public final synchronized ExpressionResolver getExpressionResolver() {
        if (this.expressionResolver == null) {
            this.expressionResolver = this.service.getExpressionResolverProvider().instance(this);
        }
        return this.expressionResolver;
    }
}

