/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import org.evrete.runtime.AbstractLhsDescriptor;
import org.evrete.runtime.AbstractWorkingMemory;
import org.evrete.runtime.BetaEndNode;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.RhsFactGroupAlpha;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.RuntimeRuleImpl;

abstract class AbstractRuntimeLhs {
    private final Collection<BetaEndNode> endNodes = new ArrayList<BetaEndNode>();
    private final AbstractLhsDescriptor descriptor;
    private final RhsFactGroup[] rhsFactGroups;

    AbstractRuntimeLhs(RuntimeRuleImpl rule, AbstractLhsDescriptor descriptor) {
        this.descriptor = descriptor;
        RhsFactGroupDescriptor[] allFactGroups = descriptor.getAllFactGroups();
        this.rhsFactGroups = new RhsFactGroup[allFactGroups.length];
        int groupIndex = 0;
        for (RhsFactGroupDescriptor groupDescriptor : allFactGroups) {
            RhsFactGroup factGroup;
            if (groupDescriptor.isLooseGroup()) {
                factGroup = new RhsFactGroupAlpha(((AbstractWorkingMemory)rule.getRuntime()).getMemory(), groupDescriptor);
            } else {
                ConditionNodeDescriptor finalNode = groupDescriptor.getFinalNode();
                assert (finalNode != null);
                boolean singleOutNode = allFactGroups.length == 1;
                BetaEndNode endNode = new BetaEndNode(rule, finalNode, singleOutNode);
                this.endNodes.add(endNode);
                factGroup = endNode;
            }
            this.rhsFactGroups[groupIndex++] = factGroup;
        }
    }

    RhsFactGroup[] getFactGroups() {
        return this.rhsFactGroups;
    }

    Collection<BetaEndNode> getEndNodes() {
        return this.endNodes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{descriptor=" + this.descriptor + '}';
    }
}

