/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.evrete.api.Action;
import org.evrete.api.ActiveField;
import org.evrete.api.FactHandle;
import org.evrete.api.Knowledge;
import org.evrete.api.MemoryFactory;
import org.evrete.api.RuleSession;
import org.evrete.api.RuntimeRule;
import org.evrete.api.Type;
import org.evrete.api.ValueHandle;
import org.evrete.api.ValueResolver;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.AtomicMemoryAction;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.runtime.LazyInsertState;
import org.evrete.runtime.MemoryActionBuffer;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.evaluation.AlphaBucketMeta;

abstract class AbstractWorkingMemory<S extends RuleSession<S>>
extends AbstractRuntime<RuntimeRule, S>
implements RuleSession<S> {
    private static final Logger LOGGER = Logger.getLogger(AbstractWorkingMemory.class.getName());
    final KnowledgeRuntime knowledge;
    final SessionMemory memory;
    final MemoryActionBuffer buffer;
    private boolean active = true;

    AbstractWorkingMemory(KnowledgeRuntime knowledge) {
        super(knowledge);
        this.knowledge = knowledge;
        this.buffer = new MemoryActionBuffer(this.getConfiguration().getAsInteger("evrete.core.insert-buffer-size", 4096));
        MemoryFactory memoryFactory = knowledge.getService().getMemoryFactoryProvider().instance(this);
        this.memory = new SessionMemory(knowledge.getConfiguration(), memoryFactory);
    }

    void invalidateSession() {
        this.active = false;
    }

    public Knowledge getParentContext() {
        return this.knowledge;
    }

    private void _assertActive() {
        if (!this.active) {
            throw new IllegalStateException("Session has been closed");
        }
    }

    public final SessionMemory getMemory() {
        return this.memory;
    }

    @Override
    public final FactHandle insert(Object fact) {
        this._assertActive();
        return this.insert(this.getTypeResolver().resolve(fact), fact);
    }

    @Override
    public final FactHandle insert(String type, Object fact) {
        this._assertActive();
        return this.insert(this.getTypeResolver().getType(type), fact);
    }

    @Override
    public Object getFact(FactHandle handle) {
        FactRecord record = null;
        AtomicMemoryAction bufferedAction = this.buffer.get(handle);
        if (bufferedAction != null) {
            if (bufferedAction.action != Action.RETRACT) {
                record = bufferedAction.factRecord.record;
            }
        } else {
            record = this.memory.get(handle.getTypeId()).getFact(handle);
        }
        return record == null ? null : record.instance;
    }

    private FactHandle insert(Type<?> type, Object fact) {
        if (fact == null) {
            throw new NullPointerException("Null facts are not supported");
        }
        if (type == null) {
            if (this.getConfiguration().getAsBoolean("evrete.core.warn-unknown-types")) {
                LOGGER.warning("Can not resolve type for " + fact + ", insert operation skipped.");
            }
            return null;
        }
        LazyInsertState innerFact = this.buildFactRecord(type, fact);
        FactHandle factHandle = this.memory.get(type).registerNewFact(innerFact);
        if (factHandle == null) {
            LOGGER.warning("Fact " + fact + " has been already inserted");
        } else {
            this.buffer.add(Action.INSERT, factHandle, innerFact);
        }
        return factHandle;
    }

    @Override
    public final void update(FactHandle handle, Object newValue) {
        this._assertActive();
        Type type = this.getTypeResolver().getType(handle.getTypeId());
        if (type == null) {
            if (this.getConfiguration().getAsBoolean("evrete.core.warn-unknown-types")) {
                LOGGER.warning("Can not resolve type for fact handle " + handle + ", update operation skipped.");
            }
        } else {
            this.buffer.add(Action.UPDATE, handle, this.buildFactRecord(type, newValue));
        }
    }

    @Override
    public final void delete(FactHandle handle) {
        this._assertActive();
        this.buffer.add(Action.RETRACT, handle, null);
    }

    private LazyInsertState buildFactRecord(Type<?> type, Object instance) {
        ValueResolver valueResolver = this.memory.valueResolver;
        ActiveField[] activeFields = this.getActiveFields(type);
        ValueHandle[] valueHandles = new ValueHandle[activeFields.length];
        Object[] transientFieldValues = new Object[activeFields.length];
        FactRecord record = new FactRecord(instance, valueHandles);
        for (ActiveField field : activeFields) {
            int idx = field.getValueIndex();
            Object fieldValue = field.readValue(instance);
            valueHandles[idx] = valueResolver.getValueHandle(field.getValueType(), fieldValue);
            transientFieldValues[idx] = fieldValue;
        }
        return new LazyInsertState(record, transientFieldValues);
    }

    @Override
    public final void forEachFact(BiConsumer<FactHandle, Object> consumer) {
        this.memory.forEachFactEntry((handle, o) -> {
            AtomicMemoryAction bufferedAction = this.buffer.get((FactHandle)handle);
            if (bufferedAction == null) {
                consumer.accept((FactHandle)handle, o);
            } else if (bufferedAction.action != Action.RETRACT) {
                consumer.accept(bufferedAction.handle, bufferedAction.factRecord.record.instance);
            }
        });
    }

    @Override
    protected final void onNewActiveField(ActiveField newField) {
        this.memory.onNewActiveField(newField);
    }

    @Override
    public final void onNewAlphaBucket(FieldsKey key, AlphaBucketMeta meta) {
        this.memory.onNewAlphaBucket(key, meta);
    }

    @Override
    public void clear() {
        this.memory.clear();
    }
}

