/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.function.Consumer;
import org.evrete.api.ActiveField;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.MemoryKeyCollection;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueHandle;
import org.evrete.api.ValueResolver;
import org.evrete.runtime.AbstractBetaConditionNode;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.BetaEvaluationValues;
import org.evrete.runtime.BetaMemoryNode;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.evaluation.BetaEvaluator;

public class BetaConditionNode
extends AbstractBetaConditionNode {
    static final BetaConditionNode[] EMPTY_ARRAY = new BetaConditionNode[0];
    private final MemoryKeyNode[] evaluationState;
    private final SourceMeta[] sourceMetas;
    private final BetaEvaluator expression;
    private final CachingEvaluator cachingEvaluator;

    BetaConditionNode(RuntimeRuleImpl rule, ConditionNodeDescriptor descriptor, BetaMemoryNode[] sources) {
        super(rule, descriptor, sources);
        this.expression = (BetaEvaluator)descriptor.getExpression().copyOf();
        ValueResolver valueResolver = ((AbstractRuleSession)rule.getRuntime()).memory.memoryFactory.getValueResolver();
        FactType[] allFactTypes = rule.getFactTypes();
        this.evaluationState = new MemoryKeyNode[allFactTypes.length];
        this.cachingEvaluator = new CachingEvaluator(this.expression);
        for (FactType type : allFactTypes) {
            MemoryKeyNode keyMeta = this.expression.getFactTypeMask().get(type.getInRuleIndex()) ? new ConditionMemoryKeyNode(type, valueResolver, this.expression, this.cachingEvaluator) : new MemoryKeyNode();
            this.evaluationState[type.getInRuleIndex()] = keyMeta;
        }
        this.sourceMetas = new SourceMeta[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            this.sourceMetas[i] = new SourceMeta(sources[i]);
        }
        BetaEvaluationValues conditionValues = ref -> this.evaluationState[ref.getFactType().getInRuleIndex()].value(ref.getFieldIndex());
        this.expression.setEvaluationState(conditionValues);
    }

    @Override
    public void commitDelta() {
        throw new UnsupportedOperationException();
    }

    private static void forEachConditionNode(BetaConditionNode node, Consumer<BetaConditionNode> consumer) {
        consumer.accept(node);
        for (BetaMemoryNode parent : node.getSources()) {
            if (!parent.getDescriptor().isConditionNode()) continue;
            BetaConditionNode.forEachConditionNode((BetaConditionNode)parent, consumer);
        }
    }

    public void computeDelta(boolean deltaOnly) {
        this.forEachKeyMode(0, false, false, new KeyMode[this.sourceMetas.length], deltaOnly);
    }

    private void forEachKeyMode(int sourceIndex, boolean hasDelta, boolean hasKnownKeys, KeyMode[] modes, boolean deltaOnly) {
        for (KeyMode mode : KeyMode.values()) {
            boolean newHasDelta = hasDelta || mode.isDeltaMode();
            boolean newHasKnownKeys = hasKnownKeys || mode == KeyMode.KNOWN_UNKNOWN;
            modes[sourceIndex] = mode;
            if (sourceIndex == this.sourceMetas.length - 1) {
                if (!newHasDelta && deltaOnly) continue;
                KeyMode destinationMode = newHasKnownKeys ? KeyMode.KNOWN_UNKNOWN : KeyMode.UNKNOWN_UNKNOWN;
                this.forEachModeSelection(destinationMode, modes);
                continue;
            }
            this.forEachKeyMode(sourceIndex + 1, newHasDelta, newHasKnownKeys, modes, deltaOnly);
        }
    }

    private void forEachModeSelection(KeyMode destinationMode, KeyMode[] sourceModes) {
        MemoryKeyCollection destination = this.getStore(destinationMode);
        for (int i = 0; i < this.sourceMetas.length; ++i) {
            if (this.sourceMetas[i].setIterator(sourceModes[i])) continue;
            return;
        }
        for (MemoryKeyNode meta : this.evaluationState) {
            meta.clear();
        }
        this.forEachMemoryKey(0, destination);
    }

    private void forEachMemoryKey(int sourceIndex, MemoryKeyCollection destination) {
        boolean last;
        SourceMeta meta = this.sourceMetas[sourceIndex];
        ReIterator<MemoryKey> it = meta.currentIterator;
        if (it.reset() == 0L) {
            return;
        }
        FactType[] types = meta.factTypes;
        boolean bl = last = sourceIndex == this.sourceMetas.length - 1;
        while (it.hasNext()) {
            this.setState(it, types);
            if (last) {
                if (!this.cachingEvaluator.test()) continue;
                for (FactType type : this.getDescriptor().getTypes()) {
                    destination.add(this.evaluationState[type.getInRuleIndex()].currentKey);
                }
                continue;
            }
            this.forEachMemoryKey(sourceIndex + 1, destination);
        }
    }

    private void setState(ReIterator<MemoryKey> it, FactType[] types) {
        for (FactType type : types) {
            this.evaluationState[type.getInRuleIndex()].setKey((MemoryKey)it.next());
        }
    }

    BetaEvaluator getExpression() {
        return this.expression;
    }

    void forEachConditionNode(Consumer<BetaConditionNode> consumer) {
        BetaConditionNode.forEachConditionNode(this, consumer);
    }

    public String toString() {
        return "{node=" + this.expression + '}';
    }

    private static class MemoryKeyNode {
        MemoryKey currentKey;

        MemoryKeyNode() {
        }

        void clear() {
            this.currentKey = null;
        }

        public void setKey(MemoryKey key) {
            this.currentKey = key;
        }

        Object value(int fieldIndex) {
            throw new UnsupportedOperationException();
        }
    }

    private static class CachingEvaluator {
        private final BetaEvaluator delegate;
        private boolean cached = false;
        private boolean lastResponse;

        CachingEvaluator(BetaEvaluator delegate) {
            this.delegate = delegate;
        }

        void valuesChanged() {
            this.cached = false;
        }

        boolean test() {
            if (!this.cached) {
                this.lastResponse = this.delegate.test();
                this.cached = true;
            }
            return this.lastResponse;
        }
    }

    private static class ConditionMemoryKeyNode
    extends MemoryKeyNode {
        private final FieldNode[] fieldNodes;

        ConditionMemoryKeyNode(FactType type, ValueResolver valueResolver, BetaEvaluator evaluator, CachingEvaluator cachingEvaluator) {
            ActiveField[] fields = type.getFields().getFields();
            this.fieldNodes = new FieldNode[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                ActiveField field = fields[i];
                FieldNode fieldNode = evaluator.evaluatesField(field) ? new ConditionFieldNode(valueResolver, cachingEvaluator) : new FieldNode(valueResolver);
                this.fieldNodes[i] = fieldNode;
            }
        }

        @Override
        void clear() {
            super.clear();
            for (FieldNode fn : this.fieldNodes) {
                fn.clear();
            }
        }

        @Override
        Object value(int fieldIndex) {
            return this.fieldNodes[fieldIndex].value;
        }

        @Override
        public void setKey(MemoryKey key) {
            if (key != this.currentKey) {
                for (int i = 0; i < this.fieldNodes.length; ++i) {
                    this.fieldNodes[i].update(key.get(i));
                }
                this.currentKey = key;
            }
        }
    }

    private static class SourceMeta {
        final BetaMemoryNode source;
        final FactType[] factTypes;
        ReIterator<MemoryKey> currentIterator;
        KeyMode currentMode;

        SourceMeta(BetaMemoryNode source) {
            this.source = source;
            this.factTypes = source.getDescriptor().getTypes();
        }

        boolean setIterator(KeyMode mode) {
            this.currentMode = mode;
            this.currentIterator = this.source.iterator(mode);
            return this.currentIterator.reset() > 0L;
        }
    }

    private static class ConditionFieldNode
    extends FieldNode {
        private final CachingEvaluator evaluator;

        ConditionFieldNode(ValueResolver valueResolver, CachingEvaluator evaluator) {
            super(valueResolver);
            this.evaluator = evaluator;
        }

        @Override
        void update(ValueHandle handle) {
            if (handle != this.lastHandle) {
                this.value = this.valueResolver.getValue(handle);
                this.lastHandle = handle;
                this.evaluator.valuesChanged();
            }
        }
    }

    private static class FieldNode {
        final ValueResolver valueResolver;
        protected Object value;
        ValueHandle lastHandle;

        FieldNode(ValueResolver valueResolver) {
            this.valueResolver = valueResolver;
        }

        final void clear() {
            this.lastHandle = null;
            this.value = null;
        }

        void update(ValueHandle handle) {
            if (handle != this.lastHandle) {
                this.value = this.valueResolver.getValue(handle);
                this.lastHandle = handle;
            }
        }
    }
}

