/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import org.evrete.api.ActiveField;
import org.evrete.api.FieldToValueHandle;
import org.evrete.api.ValueHandle;

class FactRecord
implements FieldToValueHandle {
    final Object instance;
    private ValueHandle[] fieldValues;
    private int version = 0;

    FactRecord(Object instance, ValueHandle[] fieldValues) {
        this.instance = instance;
        this.fieldValues = fieldValues;
    }

    @Override
    public ValueHandle apply(ActiveField activeField) {
        return this.fieldValues[activeField.getValueIndex()];
    }

    public int getVersion() {
        return this.version;
    }

    final void appendValue(ActiveField field, ValueHandle value) {
        assert (this.fieldValues.length == field.getValueIndex());
        this.fieldValues = Arrays.copyOf(this.fieldValues, this.fieldValues.length + 1);
        this.fieldValues[field.getValueIndex()] = value;
    }

    void updateVersion(int newVersion) {
        this.version = newVersion;
    }

    ValueHandle[] getFieldValues() {
        return this.fieldValues;
    }

    public String toString() {
        return "{obj=" + this.instance + ", ver=" + this.version + ", data=" + Arrays.toString(this.fieldValues) + '}';
    }
}

