/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.StringJoiner;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.InnerFactMemory;
import org.evrete.api.SharedBetaFactStorage;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.FieldsMemoryBucket;
import org.evrete.runtime.LazyInsertState;
import org.evrete.runtime.MemoryComponent;
import org.evrete.runtime.evaluation.AlphaBucketMeta;

public class FieldsMemory
extends MemoryComponent
implements InnerFactMemory {
    private final FieldsKey typeFields;
    private final ArrayOf<FieldsMemoryBucket> alphaBuckets;

    FieldsMemory(MemoryComponent runtime, FieldsKey typeFields) {
        super(runtime);
        this.typeFields = typeFields;
        this.alphaBuckets = new ArrayOf<FieldsMemoryBucket>(FieldsMemoryBucket.class);
    }

    @Override
    protected void clearLocalData() {
    }

    @Override
    void insert(FactHandleVersioned value, LazyInsertState insertState) {
        this.alphaBuckets.forEach(bucket -> bucket.insert(value, insertState));
    }

    public SharedBetaFactStorage get(AlphaBucketMeta mask) {
        int bucketIndex = mask.getBucketIndex();
        if (bucketIndex >= ((FieldsMemoryBucket[])this.alphaBuckets.data).length) {
            throw new IllegalArgumentException("No alpha bucket created for " + mask);
        }
        SharedBetaFactStorage storage = ((FieldsMemoryBucket[])this.alphaBuckets.data)[bucketIndex].getFieldData();
        if (storage == null) {
            throw new IllegalArgumentException("No alpha bucket created for " + mask);
        }
        return storage;
    }

    @Override
    public void commitChanges() {
        for (FieldsMemoryBucket bucket : (FieldsMemoryBucket[])this.alphaBuckets.data) {
            bucket.commitChanges();
        }
    }

    FieldsMemoryBucket getCreate(AlphaBucketMeta alphaMeta) {
        return this.alphaBuckets.computeIfAbsent(alphaMeta.getBucketIndex(), k -> new FieldsMemoryBucket(this, this.typeFields, alphaMeta));
    }

    public String toString() {
        StringJoiner sj = new StringJoiner("\n");
        this.alphaBuckets.forEach(bucket -> sj.add(bucket.toString()));
        return sj.toString();
    }
}

