/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.api.FactHandleVersioned;
import org.evrete.api.SharedBetaFactStorage;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.LazyInsertState;
import org.evrete.runtime.MemoryComponent;
import org.evrete.runtime.evaluation.AlphaBucketMeta;

class FieldsMemoryBucket
extends MemoryComponent {
    private final SharedBetaFactStorage fieldData;
    private final AlphaBucketMeta alphaMask;

    FieldsMemoryBucket(MemoryComponent runtime, FieldsKey typeFields, AlphaBucketMeta alphaMask) {
        super(runtime);
        this.alphaMask = alphaMask;
        this.fieldData = this.memoryFactory.newBetaStorage(typeFields.getFields());
    }

    @Override
    protected void clearLocalData() {
        this.fieldData.clear();
    }

    SharedBetaFactStorage getFieldData() {
        return this.fieldData;
    }

    @Override
    public void commitChanges() {
        this.fieldData.commitChanges();
    }

    @Override
    void insert(FactHandleVersioned value, LazyInsertState insertState) {
        FactRecord key = insertState.record;
        if (insertState.test(this.alphaMask)) {
            this.fieldData.insert(key, value);
        }
    }

    public String toString() {
        return this.fieldData.toString();
    }
}

