/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.api.FieldToValue;
import org.evrete.api.ValueResolver;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.evaluation.AlphaEvaluator;

class LazyInsertState {
    final FactRecord record;
    private final Object[] transientFieldValues;
    private final FieldToValue values;

    LazyInsertState(FactRecord record, Object[] transientFieldValues) {
        this.record = record;
        this.transientFieldValues = transientFieldValues;
        this.values = activeField -> transientFieldValues[activeField.getValueIndex()];
    }

    LazyInsertState(ValueResolver valueResolver, FactRecord record) {
        this.record = record;
        this.transientFieldValues = new Object[record.getFieldValues().length];
        boolean[] fieldReadFlags = new boolean[record.getFieldValues().length];
        this.values = field -> {
            int idx = field.getValueIndex();
            Object v = this.transientFieldValues[idx];
            if (!fieldReadFlags[idx]) {
                v = this.transientFieldValues[idx] = valueResolver.getValue(record.getFieldValues()[idx]);
                fieldReadFlags[idx] = true;
            }
            return v;
        };
    }

    boolean test(AlphaBucketMeta meta) {
        if (meta.isEmpty()) {
            return true;
        }
        for (int i = 0; i < meta.alphaEvaluators.length; ++i) {
            AlphaEvaluator e = meta.alphaEvaluators[i];
            if (e.test(this.values) == meta.requiredValues[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.record.toString();
    }
}

