/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.BiPredicate;
import java.util.logging.Logger;
import org.evrete.api.Action;
import org.evrete.api.FactHandle;
import org.evrete.collections.LinearHashSet;
import org.evrete.runtime.AtomicMemoryAction;
import org.evrete.runtime.LazyInsertState;

class MemoryActionBuffer {
    private static final Logger LOGGER = Logger.getLogger(MemoryActionBuffer.class.getName());
    private static final BiPredicate<AtomicMemoryAction, FactHandle> SEARCH_FUNCTION = (existing, factHandle) -> existing.handle.equals(factHandle);
    private final LinearHashSet<AtomicMemoryAction> queue;
    private final int[] actionCounts = new int[Action.values().length];
    private int totalActions = 0;

    MemoryActionBuffer(int minCapacity) {
        this.queue = new LinearHashSet(minCapacity);
    }

    AtomicMemoryAction get(FactHandle factHandle) {
        int hash = factHandle.hashCode();
        int addr = this.queue.findBinIndex((AtomicMemoryAction)((Object)factHandle), hash, SEARCH_FUNCTION);
        return (AtomicMemoryAction)this.queue.get(addr);
    }

    synchronized void add(Action action, FactHandle factHandle, LazyInsertState factRecord) {
        this.queue.resize();
        int hash = factHandle.hashCode();
        int addr = this.queue.findBinIndex((AtomicMemoryAction)((Object)factHandle), hash, SEARCH_FUNCTION);
        AtomicMemoryAction existingAction = (AtomicMemoryAction)this.queue.get(addr);
        if (existingAction == null) {
            this.queue.saveDirect(new AtomicMemoryAction(action, factHandle, factRecord), addr);
            int n = action.ordinal();
            this.actionCounts[n] = this.actionCounts[n] + 1;
            ++this.totalActions;
        } else {
            switch (action) {
                case INSERT: {
                    LOGGER.warning("Fact has been already inserted, operation skipped.");
                    break;
                }
                case UPDATE: {
                    switch (existingAction.action) {
                        case RETRACT: {
                            LOGGER.warning("An attempt was made to update a fact that has been just deleted, update operation skipped");
                            break;
                        }
                        case INSERT: 
                        case UPDATE: {
                            existingAction.factRecord = factRecord;
                        }
                    }
                    break;
                }
                case RETRACT: {
                    switch (existingAction.action) {
                        case RETRACT: {
                            break;
                        }
                        case INSERT: {
                            existingAction.action = Action.RETRACT;
                            int n = Action.INSERT.ordinal();
                            this.actionCounts[n] = this.actionCounts[n] - 1;
                            int n2 = Action.RETRACT.ordinal();
                            this.actionCounts[n2] = this.actionCounts[n2] + 1;
                            break;
                        }
                        case UPDATE: {
                            existingAction.action = Action.RETRACT;
                            int n = Action.UPDATE.ordinal();
                            this.actionCounts[n] = this.actionCounts[n] - 1;
                            int n3 = Action.RETRACT.ordinal();
                            this.actionCounts[n3] = this.actionCounts[n3] + 1;
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    boolean hasData() {
        return this.totalActions > 0;
    }

    Iterator<AtomicMemoryAction> actions() {
        return this.queue.iterator();
    }

    int deltaOperations() {
        return this.actionCounts[Action.INSERT.ordinal()] + this.actionCounts[Action.UPDATE.ordinal()];
    }

    void clear() {
        Arrays.fill(this.actionCounts, 0);
        this.totalActions = 0;
        this.queue.clear();
    }

    public String toString() {
        return "{queue=" + this.queue + ", actions=" + Arrays.toString(this.actionCounts) + ", total=" + this.totalActions + '}';
    }
}

