/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.evrete.runtime.FactType;
import org.evrete.util.Bits;

public abstract class NodeDescriptor {
    private final Bits factTypeMask = new Bits();
    private final Bits typeMask = new Bits();
    private final NodeDescriptor[] sources;
    private final FactType[] factTypes;

    NodeDescriptor(Set<? extends NodeDescriptor> sources) {
        this.sources = new NodeDescriptor[sources.size()];
        HashSet<FactType> types = new HashSet<FactType>();
        int sourceId = 0;
        for (NodeDescriptor nodeDescriptor : sources) {
            types.addAll(Arrays.asList(nodeDescriptor.factTypes));
            this.sources[sourceId++] = nodeDescriptor;
        }
        for (FactType t : this.factTypes = FactType.toArray(types)) {
            this.setMaskBits(t);
        }
    }

    NodeDescriptor(FactType entryType) {
        this.sources = new NodeDescriptor[0];
        this.factTypes = new FactType[]{entryType};
        this.setMaskBits(entryType);
    }

    private void setMaskBits(FactType t) {
        this.factTypeMask.set(t.getInRuleIndex());
        this.typeMask.set(t.getType().getId());
    }

    public abstract boolean isConditionNode();

    Bits getFactTypeMask() {
        return this.factTypeMask;
    }

    Bits getTypeMask() {
        return this.typeMask;
    }

    public FactType[] getTypes() {
        return this.factTypes;
    }

    public final NodeDescriptor[] getSources() {
        return this.sources;
    }
}

