/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueHandle;
import org.evrete.collections.CollectionReIterator;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.SessionMemory;

public class RhsFactGroupAlpha
implements RhsFactGroup {
    private static final VR KEY_MAIN = new VR(KeyMode.MAIN.ordinal());
    private static final VR KEY_DELTA = new VR(KeyMode.KNOWN_UNKNOWN.ordinal());
    private final FactType[] types;
    private final ReIterator<MemoryKey> deltaKeyIterator;
    private final ReIterator<MemoryKey> mainKeyIterator;
    private final SessionMemory memory;

    RhsFactGroupAlpha(SessionMemory memory, RhsFactGroupDescriptor descriptor) {
        this.types = descriptor.getTypes();
        assert (this.types.length > 0);
        if (this.types.length > 24) {
            throw new UnsupportedOperationException("Too many alpha nodes, another implementation required");
        }
        this.memory = memory;
        ArrayList<VR> mainCollection = new ArrayList<VR>();
        for (int i = 0; i < this.types.length; ++i) {
            mainCollection.add(KEY_MAIN);
        }
        this.mainKeyIterator = new CollectionReIterator(mainCollection);
        ArrayList<VR> deltaCollection = new ArrayList<VR>();
        for (int i = 1; i < 1 << this.types.length; ++i) {
            for (int bit = 0; bit < this.types.length; ++bit) {
                if ((i & 1 << bit) == 0) {
                    deltaCollection.add(KEY_MAIN);
                    continue;
                }
                deltaCollection.add(KEY_DELTA);
            }
        }
        this.deltaKeyIterator = new CollectionReIterator(deltaCollection);
    }

    @Override
    public FactType[] types() {
        return this.types;
    }

    @Override
    public ReIterator<FactHandleVersioned> factIterator(FactType type, MemoryKey row) {
        KeyMode mode = KeyMode.values()[row.getMetaValue()];
        return this.memory.get(type.getType()).get(type.getFields()).get(type.getAlphaMask()).values(mode, row);
    }

    @Override
    public ReIterator<MemoryKey> keyIterator(boolean delta) {
        return delta ? this.deltaKeyIterator : this.mainKeyIterator;
    }

    private static class VR
    implements MemoryKey {
        private final int transientValue;

        VR(int transientValue) {
            this.transientValue = transientValue;
        }

        @Override
        public ValueHandle get(int fieldIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getMetaValue() {
            return this.transientValue;
        }

        @Override
        public void setMetaValue(int i) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.transientValue == 0 ? "MAIN" : "DELTA";
        }
    }
}

