/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Iterator;
import java.util.function.BiConsumer;
import org.evrete.Configuration;
import org.evrete.api.ActiveField;
import org.evrete.api.FactHandle;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.MemoryFactory;
import org.evrete.api.SharedBetaFactStorage;
import org.evrete.api.Type;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.FactType;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.LazyInsertState;
import org.evrete.runtime.MemoryComponent;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.evaluation.AlphaBucketMeta;

public class SessionMemory
extends MemoryComponent
implements Iterable<TypeMemory> {
    private final ArrayOf<TypeMemory> typedMemories = new ArrayOf<TypeMemory>(new TypeMemory[0]);

    SessionMemory(Configuration configuration, MemoryFactory memoryFactory) {
        super(memoryFactory, configuration);
    }

    @Override
    protected void clearLocalData() {
    }

    void forEachFactEntry(BiConsumer<FactHandle, Object> consumer) {
        this.typedMemories.forEach(tm -> tm.forEachEntry((handle, record) -> consumer.accept((FactHandle)handle, record.instance)));
    }

    @Override
    public Iterator<TypeMemory> iterator() {
        return this.typedMemories.iterator();
    }

    void touchMemory(FieldsKey key, AlphaBucketMeta alphaMeta) {
        Type<?> t = key.getType();
        this.get(t).touchMemory(key, alphaMeta);
    }

    synchronized void onNewActiveField(ActiveField newField) {
        Type<?> t = newField.getDeclaringType();
        TypeMemory tm = this.get(t);
        tm.onNewActiveField(newField);
    }

    void onNewAlphaBucket(FieldsKey key, AlphaBucketMeta meta) {
        Type<?> t = key.getType();
        TypeMemory tm = this.typedMemories.get(t.getId());
        if (tm == null) {
            tm = new TypeMemory(this, t);
            this.typedMemories.set(t.getId(), tm);
        } else {
            tm.onNewAlphaBucket(key, meta);
        }
    }

    SharedBetaFactStorage getBetaFactStorage(FactType factType) {
        Type<?> t = factType.getType();
        FieldsKey fields = factType.getFields();
        AlphaBucketMeta mask = factType.getAlphaMask();
        return this.get(t).get(fields).get(mask);
    }

    public TypeMemory get(Type<?> t) {
        TypeMemory m = this.typedMemories.get(t.getId());
        if (m == null) {
            m = new TypeMemory(this, t);
            this.typedMemories.set(t.getId(), m);
        }
        return m;
    }

    public TypeMemory get(int typeId) {
        TypeMemory m = this.typedMemories.get(typeId);
        if (m == null) {
            throw new IllegalStateException("Unknown type id: " + typeId);
        }
        return m;
    }

    @Override
    void insert(FactHandleVersioned value, LazyInsertState insertState) {
        throw new UnsupportedOperationException("Direct insert not supported");
    }

    @Override
    public void commitChanges() {
        for (MemoryComponent child : this.childComponents()) {
            child.commitChanges();
        }
    }
}

