/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.evrete.api.Action;
import org.evrete.api.ActiveField;
import org.evrete.api.FactHandle;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.FactStorage;
import org.evrete.api.ReIterator;
import org.evrete.api.Type;
import org.evrete.api.ValueHandle;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.FieldsMemory;
import org.evrete.runtime.LazyInsertState;
import org.evrete.runtime.MemoryComponent;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.evaluation.AlphaBucketMeta;

public final class TypeMemory
extends MemoryComponent {
    private static final Logger LOGGER = Logger.getLogger(TypeMemory.class.getName());
    private final Map<FieldsKey, FieldsMemory> betaMemories = new HashMap<FieldsKey, FieldsMemory>();
    private final FactStorage<FactRecord> factStorage;
    private final Type<?> type;

    TypeMemory(SessionMemory sessionMemory, Type<?> type) {
        super(sessionMemory);
        String identityMethod;
        this.type = type;
        switch (identityMethod = this.configuration.getProperty("evrete.core.fact-identity-strategy")) {
            case "equals": {
                this.factStorage = this.memoryFactory.newFactStorage(type, FactRecord.class, (o1, o2) -> Objects.equals(o1.instance, o2.instance));
                break;
            }
            case "identity": {
                this.factStorage = this.memoryFactory.newFactStorage(type, FactRecord.class, (o1, o2) -> o1.instance == o2.instance);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid identity method '" + identityMethod + "' in the configuration. Expected values are '" + "equals" + "' or '" + "identity" + "'");
            }
        }
    }

    FactHandle registerNewFact(LazyInsertState insertState) {
        return this.factStorage.insert(insertState.record);
    }

    public Type<?> getType() {
        return this.type;
    }

    @Override
    protected void clearLocalData() {
        this.factStorage.clear();
    }

    void processMemoryChange(Action action, FactHandle handle, LazyInsertState factRecord) {
        switch (action) {
            case RETRACT: {
                this.factStorage.delete(handle);
                return;
            }
            case INSERT: {
                this.insert(new FactHandleVersioned(handle), factRecord);
                return;
            }
            case UPDATE: {
                this.performUpdate(handle, factRecord);
                return;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    void insert(FactHandleVersioned value, LazyInsertState insertState) {
        for (MemoryComponent child : this.childComponents()) {
            child.insert(value, insertState);
        }
    }

    @Override
    public void commitChanges() {
        for (MemoryComponent child : this.childComponents()) {
            child.commitChanges();
        }
    }

    private void performUpdate(FactHandle handle, LazyInsertState state) {
        FactRecord factRecord = state.record;
        FactRecord previous = this.factStorage.getFact(handle);
        if (previous == null) {
            LOGGER.warning("Unknown fact handle " + handle + ". Update operation skipped.");
        } else {
            int newVersion = previous.getVersion() + 1;
            factRecord.updateVersion(newVersion);
            this.factStorage.update(handle, factRecord);
            FactHandleVersioned versioned = new FactHandleVersioned(handle, newVersion);
            this.insert(versioned, state);
        }
    }

    void forEachEntry(BiConsumer<FactHandle, FactRecord> consumer) {
        this.factStorage.iterator().forEachRemaining(entry -> consumer.accept(entry.getHandle(), (FactRecord)entry.getInstance()));
    }

    public final FieldsMemory get(FieldsKey fields) {
        FieldsMemory fm = this.betaMemories.get(fields);
        if (fm == null) {
            throw new IllegalArgumentException("No key memory exists for " + fields);
        }
        return fm;
    }

    FactRecord getFact(FactHandle handle) {
        return this.factStorage.getFact(handle);
    }

    MemoryComponent touchMemory(FieldsKey key, AlphaBucketMeta alphaMeta) {
        return this.betaMemories.computeIfAbsent(key, k -> new FieldsMemory(this, key)).getCreate(alphaMeta);
    }

    void onNewAlphaBucket(FieldsKey key, AlphaBucketMeta meta) {
        MemoryComponent mc = this.touchMemory(key, meta);
        this.forEachEntry((fh, rec) -> mc.insert(new FactHandleVersioned((FactHandle)fh, rec.getVersion()), new LazyInsertState(this.valueResolver, (FactRecord)rec)));
        mc.commitChanges();
    }

    final void onNewActiveField(ActiveField newField) {
        ReIterator allFacts = this.factStorage.iterator();
        while (allFacts.hasNext()) {
            FactStorage.Entry rec = (FactStorage.Entry)allFacts.next();
            Object fieldValue = newField.readValue(((FactRecord)rec.getInstance()).instance);
            ValueHandle valueHandle = this.valueResolver.getValueHandle(newField.getValueType(), fieldValue);
            ((FactRecord)rec.getInstance()).appendValue(newField, valueHandle);
            this.factStorage.update(rec.getHandle(), (FactRecord)rec.getInstance());
        }
    }

    public String toString() {
        String facts = "\n" + this.factStorage.toString();
        facts = facts.replaceAll("\n", "\n\t\t");
        StringJoiner betaJ = new StringJoiner("\n");
        this.betaMemories.forEach((fieldsKey, fieldsMemory) -> {
            String s = "\n" + fieldsKey + "\n\t" + fieldsMemory;
            betaJ.add(s);
        });
        String beta = betaJ.toString();
        beta = beta.replaceAll("\n\t\n", "\n");
        beta = beta.replaceAll("\n", "\n\t\t");
        return "type=" + this.type.getJavaType().getSimpleName() + "\n\tbeta=" + beta + "\n\tfacts=" + facts;
    }
}

