/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.evrete.runtime.evaluation.AlphaEvaluator;

public abstract class AlphaBucketMeta {
    private static final Set<AlphaEvaluator.Match> EMPTY_COMPONENTS = new HashSet<AlphaEvaluator.Match>();
    public final AlphaEvaluator[] alphaEvaluators;
    public final boolean[] requiredValues;
    final Set<AlphaEvaluator.Match> key;
    private final int bucketIndex;

    private AlphaBucketMeta(int bucketIndex, Set<AlphaEvaluator.Match> matches) {
        this.bucketIndex = bucketIndex;
        this.key = matches;
        ArrayList<AlphaEvaluator.Match> sortedMatches = new ArrayList<AlphaEvaluator.Match>(matches);
        sortedMatches.sort(Comparator.comparingDouble(o -> o.matched.getDelegate().getComplexity()));
        this.alphaEvaluators = new AlphaEvaluator[sortedMatches.size()];
        this.requiredValues = new boolean[sortedMatches.size()];
        int i = 0;
        for (AlphaEvaluator.Match match : sortedMatches) {
            this.alphaEvaluators[i] = match.matched;
            this.requiredValues[i] = match.direct;
            ++i;
        }
    }

    public static AlphaBucketMeta factory(int bucketIndex, Set<AlphaEvaluator.Match> matches) {
        if (matches.isEmpty()) {
            return new Empty(bucketIndex);
        }
        return new Default(bucketIndex, matches);
    }

    public abstract boolean sameKey(Set<AlphaEvaluator.Match> var1);

    public abstract boolean isEmpty();

    public final int getBucketIndex() {
        return this.bucketIndex;
    }

    public String toString() {
        return "{bucket=" + this.bucketIndex + ", indices=" + Arrays.toString(this.alphaEvaluators) + ", values=" + Arrays.toString(this.requiredValues) + '}';
    }

    private static final class Empty
    extends AlphaBucketMeta {
        Empty(int bucketIndex) {
            super(bucketIndex, EMPTY_COMPONENTS);
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }

        @Override
        public boolean sameKey(Set<AlphaEvaluator.Match> other) {
            return other.isEmpty();
        }
    }

    private static final class Default
    extends AlphaBucketMeta {
        Default(int bucketIndex, Set<AlphaEvaluator.Match> matches) {
            super(bucketIndex, matches);
        }

        @Override
        public boolean sameKey(Set<AlphaEvaluator.Match> other) {
            return this.key.equals(other);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }
}

