/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import org.evrete.api.ActiveField;
import org.evrete.api.EvaluationListener;
import org.evrete.api.EvaluationListeners;
import org.evrete.api.FieldToValue;
import org.evrete.runtime.evaluation.EvaluatorWrapper;

public class AlphaEvaluator
implements EvaluationListeners {
    private final ActiveField[] activeDescriptor;
    private final EvaluatorWrapper delegate;

    public AlphaEvaluator(EvaluatorWrapper e, ActiveField[] activeFields) {
        this.activeDescriptor = activeFields;
        this.delegate = e;
    }

    public static Match search(AlphaEvaluator[] scope, EvaluatorWrapper subject) {
        block5: for (AlphaEvaluator evaluator : scope) {
            int cmp = evaluator.delegate.compare(subject);
            switch (cmp) {
                case 1: {
                    return new Match(evaluator, true);
                }
                case -1: {
                    return new Match(evaluator, false);
                }
                case 0: {
                    continue block5;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return null;
    }

    public EvaluatorWrapper getDelegate() {
        return this.delegate;
    }

    public boolean test(FieldToValue values) {
        return this.delegate.test(i -> values.apply(this.activeDescriptor[i]));
    }

    @Override
    public void addListener(EvaluationListener listener) {
        this.delegate.addListener(listener);
    }

    @Override
    public void removeListener(EvaluationListener listener) {
        this.delegate.removeListener(listener);
    }

    public static class Match {
        final AlphaEvaluator matched;
        final boolean direct;

        public Match(AlphaEvaluator matched, boolean direct) {
            this.matched = matched;
            this.direct = direct;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Match match = (Match)o;
            return this.direct == match.direct && this.matched.equals(match.matched);
        }

        public int hashCode() {
            return this.matched.hashCode() + 37 * Boolean.hashCode(this.direct);
        }
    }
}

