/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.evrete.api.ActiveField;
import org.evrete.api.FieldReference;
import org.evrete.api.IntToValue;
import org.evrete.api.NamedType;
import org.evrete.api.TypeField;
import org.evrete.runtime.BetaEvaluationValues;
import org.evrete.runtime.BetaFieldReference;
import org.evrete.runtime.FactType;
import org.evrete.runtime.evaluation.BetaEvaluator;
import org.evrete.runtime.evaluation.EvaluatorWrapper;
import org.evrete.util.Bits;

public class BetaEvaluatorSingle
extends EvaluatorWrapper
implements BetaEvaluator {
    public static final BetaEvaluatorSingle[] ZERO_ARRAY = new BetaEvaluatorSingle[0];
    private final BetaFieldReference[] descriptor;
    private final Bits factTypeMask;
    private final Set<FactType> descriptor1;
    private IntToValue stateValues;
    private final Set<ActiveField> fields;

    BetaEvaluatorSingle(EvaluatorWrapper delegate, Function<NamedType, FactType> typeFunction) {
        super(delegate);
        this.factTypeMask = new Bits();
        this.fields = new HashSet<ActiveField>();
        FieldReference[] evaluatorDescriptor = delegate.descriptor();
        this.descriptor = new BetaFieldReference[evaluatorDescriptor.length];
        HashSet<FactType> factTypes = new HashSet<FactType>();
        for (int i = 0; i < this.descriptor.length; ++i) {
            BetaFieldReference bfr;
            FieldReference fieldReference = evaluatorDescriptor[i];
            FactType factType = typeFunction.apply(fieldReference.type());
            TypeField field = fieldReference.field();
            this.descriptor[i] = bfr = new BetaFieldReference(factType, field);
            this.factTypeMask.set(factType.getInRuleIndex());
            this.fields.add(bfr.getActiveField());
            factTypes.add(factType);
        }
        this.descriptor1 = Collections.unmodifiableSet(factTypes);
    }

    private BetaEvaluatorSingle(BetaEvaluatorSingle other) {
        super(other);
        this.factTypeMask = other.factTypeMask;
        this.descriptor = other.descriptor;
        this.stateValues = other.stateValues;
        this.descriptor1 = other.descriptor1;
        this.fields = other.fields;
    }

    @Override
    public boolean evaluatesField(ActiveField field) {
        return this.fields.contains(field);
    }

    @Override
    public Set<FactType> factTypes() {
        return this.descriptor1;
    }

    BetaFieldReference[] betaDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return this.getDelegate().toString();
    }

    @Override
    public Bits getFactTypeMask() {
        return this.factTypeMask;
    }

    @Override
    public BetaEvaluatorSingle copyOf() {
        return new BetaEvaluatorSingle(this);
    }

    @Override
    public void setEvaluationState(BetaEvaluationValues values) {
        this.stateValues = i -> values.apply(this.descriptor[i]);
    }

    @Override
    public boolean test() {
        return this.test(this.stateValues);
    }
}

