/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.function.BiPredicate;
import org.evrete.Configuration;
import org.evrete.api.ActiveField;
import org.evrete.api.FactStorage;
import org.evrete.api.MemoryFactory;
import org.evrete.api.MemoryKeyCollection;
import org.evrete.api.RuntimeContext;
import org.evrete.api.SharedBetaFactStorage;
import org.evrete.api.Type;
import org.evrete.api.ValueResolver;
import org.evrete.runtime.FactType;
import org.evrete.spi.minimal.DefaultFactStorage;
import org.evrete.spi.minimal.DefaultMemoryKeyCollection;
import org.evrete.spi.minimal.DefaultValueResolver;
import org.evrete.spi.minimal.SharedAlphaData;
import org.evrete.spi.minimal.SharedBetaData;
import org.evrete.spi.minimal.SharedBetaDataPlain;

class DefaultMemoryFactory
implements MemoryFactory {
    private final DefaultValueResolver valueResolver = new DefaultValueResolver();
    private static final String CONFIG_BETA_INITIAL_SIZE = "evrete.impl.beta-memory-initial-size";
    private static final String CONFIG_FACT_STORAGE_CAPACITY = "evrete.impl.fact-storage-initial-size";
    private static final int FACT_STORAGE_CAPACITY_DEFAULT = 8192;
    private static final int BETA_INITIAL_SIZE_DEFAULT = 4096;
    private final Configuration configuration;

    DefaultMemoryFactory(RuntimeContext<?> context) {
        this.configuration = context.getConfiguration();
    }

    @Override
    public MemoryKeyCollection newMemoryKeyCollection(FactType[] types) {
        return new DefaultMemoryKeyCollection();
    }

    @Override
    public ValueResolver getValueResolver() {
        return this.valueResolver;
    }

    @Override
    public <Z> FactStorage<Z> newFactStorage(Type<?> type, Class<Z> storageClass, BiPredicate<Z, Z> identityFunction) {
        int minCapacity = this.configuration.getAsInteger(CONFIG_FACT_STORAGE_CAPACITY, 8192);
        return new DefaultFactStorage<Z>(type, identityFunction, minCapacity);
    }

    @Override
    public SharedBetaFactStorage newBetaStorage(ActiveField[] fields) {
        int initialSize = this.configuration.getAsInteger(CONFIG_BETA_INITIAL_SIZE, 4096);
        if (fields.length == 0) {
            return new SharedAlphaData();
        }
        return fields.length == 1 ? new SharedBetaDataPlain(initialSize, fields[0]) : new SharedBetaData(initialSize, fields);
    }
}

