/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.evrete.api.ValueHandle;
import org.evrete.api.ValueResolver;
import org.evrete.spi.minimal.ValueHandleImpl;
import org.evrete.util.NextIntSupplier;

class DefaultValueResolver
implements ValueResolver {
    private static final ValueHandle NULL_HANDLE = new ValueHandleImpl(new int[]{-1, -1});
    private static final int INITIAL_TYPE_DATA_SIZE = 128;
    private final Map<String, Integer> typeIndices = new HashMap<String, Integer>();
    private final NextIntSupplier typeIdCounter = new NextIntSupplier();
    private TypeData[] typeDataArr = new TypeData[128];

    DefaultValueResolver() {
    }

    @Override
    public ValueHandle getValueHandle(Class<?> valueType, Object value) {
        return value == null ? NULL_HANDLE : this.getValueHandleInner(valueType, value);
    }

    @Override
    public Object getValue(ValueHandle handle) {
        ValueHandleImpl impl = (ValueHandleImpl)handle;
        return impl.data[0] < 0 ? null : this.typeDataArr[impl.data[0]].values[impl.data[1]];
    }

    private synchronized ValueHandle getValueHandleInner(Class<?> valueType, Object value) {
        String typeKey = valueType.getName();
        Integer typeIdx = this.typeIndices.get(typeKey);
        if (typeIdx == null) {
            typeIdx = this.typeIdCounter.next();
            TypeData typeData = new TypeData(typeIdx);
            if (typeIdx >= this.typeDataArr.length) {
                this.typeDataArr = Arrays.copyOf(this.typeDataArr, this.typeDataArr.length * 2);
            }
            this.typeDataArr[typeIdx.intValue()] = typeData;
            this.typeIndices.put(typeKey, typeIdx);
            return typeData.getHandle(value);
        }
        return this.typeDataArr[typeIdx].getHandle(value);
    }

    private static class TypeData {
        private static final int INITIAL_VALUE_DATA_SIZE = 1024;
        private final Map<Object, ValueHandleImpl> idMap = new HashMap<Object, ValueHandleImpl>();
        private final NextIntSupplier idCounter = new NextIntSupplier();
        private final int id;
        private Object[] values;

        TypeData(int id) {
            this.id = id;
            this.values = new Object[1024];
        }

        ValueHandleImpl getHandle(Object value) {
            ValueHandleImpl handle = this.idMap.get(value);
            if (handle == null) {
                int valueId = this.idCounter.next();
                handle = new ValueHandleImpl(new int[]{this.id, valueId});
                this.idMap.put(value, handle);
                if (valueId >= this.values.length) {
                    this.values = Arrays.copyOf(this.values, this.values.length * 2);
                }
                this.values[valueId] = value;
            }
            return handle;
        }
    }
}

