/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.function.BiPredicate;
import java.util.function.Function;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.collections.LinearHashSet;
import org.evrete.spi.minimal.LinkedFactHandles;
import org.evrete.spi.minimal.MemoryKeyImplPlain;

class FieldsFactMapPlain {
    private static final BiPredicate<MapEntry, MemoryKeyImplPlain> SEARCH_PREDICATE = (entry, memoryKey) -> ((MapEntry)entry).key.equals(memoryKey);
    private static final Function<MapEntry, MemoryKey> ENTRY_MAPPER = entry -> MapEntry.access$000(entry);
    private final int myModeOrdinal;
    private final LinearHashSet<MapEntry> data;

    FieldsFactMapPlain(KeyMode myMode, int minCapacity) {
        this.myModeOrdinal = myMode.ordinal();
        this.data = new LinearHashSet(minCapacity);
    }

    public void clear() {
        this.data.clear();
    }

    void merge(FieldsFactMapPlain other) {
        other.data.forEachDataEntry(this::merge);
        other.data.clear();
    }

    private void merge(MapEntry otherEntry) {
        otherEntry.key.setMetaValue(this.myModeOrdinal);
        int addr = this.addr(otherEntry.key);
        MapEntry found = (MapEntry)this.data.get(addr);
        if (found == null) {
            this.data.add(otherEntry);
        } else {
            found.facts.consume(otherEntry.facts);
        }
    }

    ReIterator<MemoryKey> keys() {
        return this.data.iterator(ENTRY_MAPPER);
    }

    ReIterator<FactHandleVersioned> values(MemoryKeyImplPlain key) {
        int addr = this.addr(key);
        MapEntry entry = (MapEntry)this.data.get(addr);
        return entry == null ? ReIterator.emptyIterator() : entry.facts.iterator();
    }

    public void add(MemoryKeyImplPlain key, FactHandleVersioned factHandleVersioned) {
        key.setMetaValue(this.myModeOrdinal);
        this.data.resize();
        int addr = this.addr(key);
        MapEntry entry = (MapEntry)this.data.get(addr);
        if (entry == null) {
            entry = new MapEntry(key);
            this.data.saveDirect(entry, addr);
        }
        entry.facts.add(factHandleVersioned);
    }

    boolean hasKey(MemoryKeyImplPlain key) {
        int addr = this.addr(key);
        MapEntry entry = (MapEntry)this.data.get(addr);
        return entry != null;
    }

    private int addr(MemoryKeyImplPlain key) {
        return this.data.findBinIndex((MapEntry)((Object)key), key.hashCode(), SEARCH_PREDICATE);
    }

    public String toString() {
        return this.data.toString();
    }

    private static class MapEntry {
        final LinkedFactHandles facts = new LinkedFactHandles();
        private final MemoryKeyImplPlain key;

        MapEntry(MemoryKeyImplPlain key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapEntry mapEntry = (MapEntry)o;
            return this.key.equals(mapEntry.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

