/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.NoSuchElementException;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.FieldToValueHandle;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.api.SharedBetaFactStorage;
import org.evrete.api.ValueHandle;
import org.evrete.spi.minimal.LinkedFactHandles;
import org.evrete.spi.minimal.MemoryKeyImpl;

class SharedAlphaData
implements SharedBetaFactStorage {
    private final LinkedFactHandles[] dataWrappers = new LinkedFactHandles[KeyMode.values().length];
    private final KeyIterator[] keyIterators = new KeyIterator[KeyMode.values().length];

    SharedAlphaData() {
        for (KeyMode mode : KeyMode.values()) {
            int idx = mode.ordinal();
            this.dataWrappers[idx] = new LinkedFactHandles();
            this.keyIterators[idx] = new KeyIterator(mode);
        }
    }

    @Override
    public void insert(FieldToValueHandle key, FactHandleVersioned fact) {
        this.get(KeyMode.KNOWN_UNKNOWN).add(fact);
    }

    private LinkedFactHandles get(KeyMode mode) {
        return this.dataWrappers[mode.ordinal()];
    }

    @Override
    public ReIterator<MemoryKey> keys(KeyMode mode) {
        return this.keyIterators[mode.ordinal()];
    }

    @Override
    public ReIterator<FactHandleVersioned> values(KeyMode mode, MemoryKey key) {
        return this.get(mode).iterator();
    }

    @Override
    public void clear() {
        for (LinkedFactHandles wrapper : this.dataWrappers) {
            wrapper.clear();
        }
    }

    @Override
    public void commitChanges() {
        LinkedFactHandles delta = this.get(KeyMode.KNOWN_UNKNOWN);
        this.get(KeyMode.MAIN).consume(delta);
    }

    private static class KeyIterator
    implements ReIterator<MemoryKey> {
        private static final ValueHandle[] EMPTY = new ValueHandle[0];
        private final MemoryKeyImpl row = new MemoryKeyImpl(EMPTY, 0);
        private boolean hasNext = true;

        KeyIterator(KeyMode mode) {
            this.row.setMetaValue(mode.ordinal());
        }

        @Override
        public long reset() {
            this.hasNext = true;
            return 1L;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public MemoryKey next() {
            if (this.hasNext) {
                this.hasNext = false;
                return this.row;
            }
            throw new NoSuchElementException();
        }
    }
}

