/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Objects;
import org.evrete.api.ActiveField;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.FieldToValueHandle;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.api.SharedBetaFactStorage;
import org.evrete.api.ValueHandle;
import org.evrete.spi.minimal.FieldsFactMap;
import org.evrete.spi.minimal.MemoryKeyImpl;

class SharedBetaData
implements SharedBetaFactStorage {
    private final ActiveField[] fields;
    private final FieldsFactMap[] maps = new FieldsFactMap[KeyMode.values().length];

    SharedBetaData(int initialSize, ActiveField[] fields) {
        this.fields = fields;
        for (KeyMode mode : KeyMode.values()) {
            this.maps[mode.ordinal()] = new FieldsFactMap(mode, initialSize);
        }
    }

    @Override
    public ReIterator<MemoryKey> keys(KeyMode keyMode) {
        return this.get(keyMode).keys();
    }

    @Override
    public ReIterator<FactHandleVersioned> values(KeyMode mode, MemoryKey key) {
        return this.get(mode).values((MemoryKeyImpl)key);
    }

    @Override
    public void clear() {
        for (FieldsFactMap map : this.maps) {
            map.clear();
        }
    }

    private int hash(FieldToValueHandle key) {
        int hash = 0;
        for (ActiveField field : this.fields) {
            hash ^= Objects.hashCode(key.apply(field));
        }
        return hash;
    }

    @Override
    public void commitChanges() {
        FieldsFactMap main = this.get(KeyMode.MAIN);
        main.merge(this.get(KeyMode.UNKNOWN_UNKNOWN));
        main.merge(this.get(KeyMode.KNOWN_UNKNOWN));
    }

    @Override
    public void insert(FieldToValueHandle key, FactHandleVersioned value) {
        int hash = this.hash(key);
        ValueHandle[] data = new ValueHandle[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            ActiveField field = this.fields[i];
            data[i] = (ValueHandle)key.apply(field);
        }
        MemoryKeyImpl memoryKey = new MemoryKeyImpl(data, hash);
        if (this.get(KeyMode.MAIN).hasKey(memoryKey)) {
            this.get(KeyMode.KNOWN_UNKNOWN).add(memoryKey, value);
        } else {
            this.get(KeyMode.UNKNOWN_UNKNOWN).add(memoryKey, value);
        }
    }

    private FieldsFactMap get(KeyMode mode) {
        return this.maps[mode.ordinal()];
    }
}

