/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import org.evrete.api.ActiveField;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.FieldToValueHandle;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.api.SharedBetaFactStorage;
import org.evrete.api.ValueHandle;
import org.evrete.spi.minimal.FieldsFactMapPlain;
import org.evrete.spi.minimal.MemoryKeyImplPlain;

class SharedBetaDataPlain
implements SharedBetaFactStorage {
    private final ActiveField field;
    private final FieldsFactMapPlain[] maps = new FieldsFactMapPlain[KeyMode.values().length];

    SharedBetaDataPlain(int initialSize, ActiveField field) {
        this.field = field;
        for (KeyMode mode : KeyMode.values()) {
            this.maps[mode.ordinal()] = new FieldsFactMapPlain(mode, initialSize);
        }
    }

    @Override
    public ReIterator<MemoryKey> keys(KeyMode keyMode) {
        return this.get(keyMode).keys();
    }

    @Override
    public ReIterator<FactHandleVersioned> values(KeyMode mode, MemoryKey key) {
        MemoryKeyImplPlain k = (MemoryKeyImplPlain)key;
        return this.get(mode).values(k);
    }

    @Override
    public void clear() {
        for (FieldsFactMapPlain map : this.maps) {
            map.clear();
        }
    }

    @Override
    public void commitChanges() {
        FieldsFactMapPlain main = this.get(KeyMode.MAIN);
        main.merge(this.get(KeyMode.UNKNOWN_UNKNOWN));
        main.merge(this.get(KeyMode.KNOWN_UNKNOWN));
    }

    @Override
    public void insert(FieldToValueHandle key, FactHandleVersioned value) {
        ValueHandle h = (ValueHandle)key.apply(this.field);
        int hash = h.hashCode();
        MemoryKeyImplPlain memoryKey = new MemoryKeyImplPlain(h, hash);
        if (this.get(KeyMode.MAIN).hasKey(memoryKey)) {
            this.get(KeyMode.KNOWN_UNKNOWN).add(memoryKey, value);
        } else {
            this.get(KeyMode.UNKNOWN_UNKNOWN).add(memoryKey, value);
        }
    }

    private FieldsFactMapPlain get(KeyMode mode) {
        return this.maps[mode.ordinal()];
    }
}

