/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.util.BitSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.evrete.api.Copyable;

public class Bits
implements Copyable<Bits> {
    private final BitSet delegate;

    private Bits(BitSet delegate) {
        this.delegate = delegate;
    }

    public Bits() {
        this(new BitSet());
    }

    public static <T> Set<T> matchesOR(Bits mask, Collection<T> collection, Function<T, Bits> maskFunction) {
        return collection.stream().filter(node -> ((Bits)maskFunction.apply(node)).intersects(mask)).collect(Collectors.toSet());
    }

    public boolean get(int index) {
        return this.delegate.get(index);
    }

    public void set(int index) {
        this.delegate.set(index);
    }

    public void or(Bits other) {
        this.delegate.or(other.delegate);
    }

    private boolean intersects(Bits other) {
        return this.delegate.intersects(other.delegate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bits bits = (Bits)o;
        return this.delegate.equals(bits.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Bits copyOf() {
        return new Bits((BitSet)this.delegate.clone());
    }

    public String toString() {
        return this.delegate.toString();
    }
}

