/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Comparator;
import org.evrete.Configuration;
import org.evrete.KnowledgeService;
import org.evrete.api.ActivationManager;
import org.evrete.api.ActivationMode;
import org.evrete.api.ExpressionResolver;
import org.evrete.api.FluentImports;
import org.evrete.api.Listeners;
import org.evrete.api.PropertyAccess;
import org.evrete.api.Rule;
import org.evrete.api.RuleBuilder;
import org.evrete.api.TypeResolver;
import org.evrete.api.TypeResolverWrapper;

public interface RuntimeContext<C extends RuntimeContext<C>>
extends Listeners,
FluentImports<RuntimeContext<?>>,
PropertyAccess<C> {
    public static final Comparator<Rule> SALIENCE_COMPARATOR = (rule1, rule2) -> -1 * Integer.compare(rule1.getSalience(), rule2.getSalience());

    public Comparator<Rule> getRuleComparator();

    public void setRuleComparator(Comparator<Rule> var1);

    public RuleBuilder<C> newRule(String var1);

    public RuleBuilder<C> newRule();

    public void wrapTypeResolver(TypeResolverWrapper var1);

    public C setActivationMode(ActivationMode var1);

    public ExpressionResolver getExpressionResolver();

    public ClassLoader getClassLoader();

    public KnowledgeService getService();

    public void setClassLoader(ClassLoader var1);

    public Class<? extends ActivationManager> getActivationManagerFactory();

    public <A extends ActivationManager> void setActivationManagerFactory(Class<A> var1);

    public void setActivationManagerFactory(String var1);

    public TypeResolver getTypeResolver();

    public Configuration getConfiguration();

    public C appendDslRules(String var1, InputStream ... var2) throws IOException;

    public C appendDslRules(String var1, URL ... var2) throws IOException;

    public C appendDslRules(String var1, Class<?> var2) throws IOException;

    public C appendDslRules(String var1, Reader ... var2) throws IOException;

    default public C appendDslRules(String dsl, String ... sources) throws IOException {
        Reader[] readers = new Reader[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            readers[i] = new StringReader(sources[i]);
        }
        return this.appendDslRules(dsl, readers);
    }
}

