/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.evrete.AbstractRule;
import org.evrete.api.NamedType;
import org.evrete.api.RuleScope;
import org.evrete.api.Type;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.FactType;
import org.evrete.util.Bits;

public abstract class AbstractRuntimeRule
extends AbstractRule {
    final FactType[] factTypes;
    private final AbstractRuntime<?, ?> runtime;
    private final Bits typeMask = new Bits();
    private final Map<String, FactType> typeMapping = new HashMap<String, FactType>();

    AbstractRuntimeRule(AbstractRuntime<?, ?> runtime, AbstractRule other, FactType[] factTypes) {
        this(runtime, other, other.getName(), other.getSalience(), factTypes);
    }

    AbstractRuntimeRule(AbstractRuntime<?, ?> runtime, AbstractRule other, String ruleName, int salience, FactType[] factTypes) {
        super(other, ruleName, salience);
        this.runtime = runtime;
        this.factTypes = factTypes;
        for (FactType factType : factTypes) {
            this.typeMask.set(factType.getType().getId());
            if (this.typeMapping.put(factType.getVar(), factType) == null) continue;
            throw new IllegalStateException();
        }
        this.appendImports(runtime.getImportsData());
        this.setRhs(this.getLiteralRhs());
    }

    private FactType resolve(String var) {
        return Objects.requireNonNull(this.typeMapping.get(var), "No such type: '" + var + "'");
    }

    FactType resolve(NamedType type) {
        return this.resolve(type.getVar());
    }

    final boolean dependsOn(Type<?> type) {
        return this.typeMask.get(type.getId());
    }

    public FactType[] getFactTypes() {
        return this.factTypes;
    }

    @Override
    public final void setRhs(String literalRhs) {
        if (literalRhs != null) {
            this.setRhs(this.runtime.compile(literalRhs, this.factTypes, this.getImports(RuleScope.BOTH, RuleScope.RHS)));
        }
    }
}

